package storage_test

import (
	"context"

	datasource "code.justin.tv/amzn/TwitchEmailValidatorService/storage"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
)

func (s *VerifierSuite) TestOpaqueVerificationRequestSuccess() {
	email := testutils.RandEmail()
	id := testutils.RandStr(15)

	s.MockDynamoDBQueryOpaqueVerificationSuccess(id, email)

	request, err := s.Verifier.VerificationRequestByOpaqueID(context.Background(), id)

	s.Require().NoError(err)
	s.Equal(id, request.OpaqueID)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestOpaqueVerificationRequestAWSFail() {
	id := testutils.RandStr(15)

	s.MockDynamoDBQueryOpaqueVerificationFail(id)

	_, err := s.Verifier.VerificationRequestByOpaqueID(context.Background(), id)

	s.Require().Error(err)
	s.isError(AWSError, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestOpaqueVerificationRequestDoesNotExistFail() {
	id := testutils.RandStr(15)

	s.MockDynamoDBQueryOpaqueVerificationEmpty(id)

	_, err := s.Verifier.VerificationRequestByOpaqueID(context.Background(), id)

	s.Require().Error(err)
	s.isError(datasource.ErrValidationNotFound, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestOpaqueVerificationRequestMultipleFail() {
	id := testutils.RandStr(15)

	s.MockDynamoDBQueryOpaqueVerificationMultiple(id)

	_, err := s.Verifier.VerificationRequestByOpaqueID(context.Background(), id)

	s.Require().Error(err)
	s.isError(datasource.ErrMultipleValidationsFound, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestOpaqueVerificationMissingIDFail() {
	_, err := s.Verifier.VerificationRequestByOpaqueID(context.Background(), "")
	s.Require().Error(err)
	s.isError(datasource.ErrNeedOpaqueID, err)
}
