package storage

import "context"

// NotMe sends a request off to users service to soft delete an account
// It will return an error if the opaqueID does not correspond to the entry represented by email
func (ds *Verifier) NotMe(ctx context.Context, email, opaqueID string) error {
	if len(opaqueID) == 0 {
		return ErrNeedOpaqueID
	}

	if len(email) == 0 {
		return ErrNeedEmail
	}

	request, err := ds.VerificationRequestByOpaqueID(ctx, opaqueID)
	if err != nil {
		return err
	}

	if email != request.Email {
		return ErrValidationNotFound
	}

	if len(request.Key) == 0 {
		return ErrNeedKey
	}

	return ds.User.EventualHardDeleteUser(ctx, request.Key)
}
