package storage_test

import (
	"context"

	datasource "code.justin.tv/amzn/TwitchEmailValidatorService/storage"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
)

func (s *VerifierSuite) TestRejectSuccess() {
	email := testutils.RandEmail()

	s.MockDynamoDBQueryByEmailSuccess(email)
	s.MockDynamoDBPutItemSuccess()

	err := s.Verifier.Reject(context.Background(), email)

	s.Require().NoError(err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestRejectGetVerificationFail() {
	email := testutils.RandEmail()

	s.MockDynamoDBQueryByEmailFail(email)

	err := s.Verifier.Reject(context.Background(), email)

	s.Require().Error(err)
	s.isError(AWSError, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestRejectGetVerificationNotFoundFail() {
	email := testutils.RandEmail()

	s.MockDynamoDBQueryByEmailEmpty(email)

	err := s.Verifier.Reject(context.Background(), email)

	s.Require().Error(err)
	s.isError(datasource.ErrEmailNotFound, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestRejectUpsertFail() {
	email := testutils.RandEmail()

	s.MockDynamoDBQueryByEmailSuccess(email)
	s.MockDynamoDBPutItemFail()

	err := s.Verifier.Reject(context.Background(), email)

	s.Require().Error(err)
	s.isError(AWSError, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestRejectInvalidInputFail() {
	err := s.Verifier.Reject(context.Background(), "")
	s.Require().Error(err)
	s.isError(datasource.ErrNeedEmail, err)
}
