package storage

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
)

// Unreject sets a previously rejected verification request (due to a hard bounce) to "Pending"
func (ds *Verifier) Unreject(ctx context.Context, namespace, key, email string) (*models.VerificationRequest, error) {
	if len(namespace) == 0 {
		return nil, ErrNeedNamespace
	}
	if len(key) == 0 {
		return nil, ErrNeedKey
	}
	if len(email) == 0 {
		return nil, ErrNeedEmail
	}

	request, err := ds.VerificationRequest(ctx, namespace, key, email)
	if err != nil {
		return nil, err
	}

	if request.Status != models.StatusRejected {
		return nil, ErrValidationNotRejected
	}

	request.Status = models.StatusPending

	err = ds.upsertRequest(ctx, request, false)
	if err != nil {
		ds.reportAWSError(ctx, err, "datastore.verify.updateitem")
		return nil, err
	}

	return request, nil
}
