package storage

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
)

// Verify sets a request to "Verified" given an opaque ID.
// Verification happens off the opaque ID because it is done
// in response to a user's click on a URL that only contains the
// opaque ID.
func (ds *Verifier) Verify(ctx context.Context, opaqueID string) (*models.VerificationRequest, error) {
	request, err := ds.VerificationRequestByOpaqueID(ctx, opaqueID)
	if err != nil {
		return nil, err
	}

	request.Status = models.StatusVerified
	err = ds.upsertRequest(ctx, request, false)
	if err != nil {
		ds.reportAWSError(ctx, err, "datastore.verify.updateitem")
		return nil, err
	}

	return request, nil
}
