package storage_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
)

func (s *VerifierSuite) TestVerifySuccess() {
	email := testutils.RandEmail()
	opaqueID := testutils.RandStr(10)

	s.MockDynamoDBQueryOpaqueVerificationSuccess(opaqueID, email)
	s.MockDynamoDBPutItemSuccess()

	request, err := s.Verifier.Verify(context.Background(), opaqueID)

	s.Require().NoError(err)
	s.Equal(opaqueID, request.OpaqueID)
	s.Equal(models.StatusVerified, request.Status)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestVerifyGetVerificationFail() {
	opaqueID := testutils.RandStr(10)

	s.MockDynamoDBQueryOpaqueVerificationFail(opaqueID)

	_, err := s.Verifier.Verify(context.Background(), opaqueID)

	s.Require().Error(err)
	s.isError(AWSError, err)
	s.AssertExpectations()
}

func (s *VerifierSuite) TestVerifyPutItemFail() {
	email := testutils.RandEmail()
	opaqueID := testutils.RandStr(10)

	s.MockDynamoDBQueryOpaqueVerificationSuccess(opaqueID, email)
	s.MockDynamoDBPutItemFail()

	_, err := s.Verifier.Verify(context.Background(), opaqueID)

	s.Require().Error(err)
	s.isError(AWSError, err)
	s.AssertExpectations()
}
