package testutils

import (
	"math/rand"
	"time"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
)

func NewVerificationRequest() *models.VerificationRequest {
	return &models.VerificationRequest{
		Namespace:            RandStr(10),
		Key:                  RandStr(10),
		Email:                RandStr(10),
		OpaqueID:             RandStr(10),
		Status:               models.StatusPending,
		Created:              time.Now(),
		Modified:             time.Now(),
		Locale:               RandStr(20),
		CompoundKey:          RandStr(10),
		VerificationCode:     RandStr(10),
		VerificationAttempts: rand.Int(),
	}
}
