package testutils

import (
	"errors"
	"time"
)

// Eventually is a helper to wait for something to eventually happen. This may be useful for
// testing eventual consistency cases.
func Eventually(timeout time.Duration, interval time.Duration, f func() error) error {
	timer := time.NewTimer(timeout)
	defer timer.Stop()
	var lastError error
outer:
	for {
		select {
		case <-timer.C:
			break outer
		default:
			err := f()
			if err != nil {
				lastError = errors.New(err.Error())
				time.Sleep(interval)
				continue
			}

			return nil
		}
	}

	return errors.New(lastError.Error())
}
