package testutils_test

import (
	"errors"
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	"github.com/stretchr/testify/assert"
)

func TestEventually(t *testing.T) {
	testCases := []struct {
		name     string
		timeout  time.Duration
		interval time.Duration
		f        func() error
		errors   bool
	}{
		{
			name:     "success",
			timeout:  1 * time.Second,
			interval: 1 * time.Millisecond,
			f: func() error {
				return nil
			},
			errors: false,
		},
		{
			name:     "fail",
			timeout:  10 * time.Millisecond,
			interval: 1 * time.Millisecond,
			f: func() error {
				return errors.New("dummy error")
			},
			errors: true,
		},
	}

	for _, tt := range testCases {
		t.Run(tt.name, func(t *testing.T) {
			err := testutils.Eventually(tt.timeout, tt.interval, tt.f)
			assert.Equal(t, tt.errors, err != nil)
		})
	}
}
