package testutils

import (
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server"

	"code.justin.tv/amzn/TwitchEmailValidatorService/mocks"
)

// Mocks contains testify mocks used in tests. This struct is intended
// to reduce boilerplate of maintaining mocks in test suites.
//
// To add a new mock:
//
//  1. In the Mocks struct, add a new field with the mocks concrete type
//  2. Update Mocks.Init to assign a new mock instances.
//  3. Update Mocks.AssertExpectations to all AssertExpectations on the mock instance.
//  4. Update Clients(), APIClients(), or WorkflowClients()  as needed to assign the mock
//     instance to the Clients struct

type Mocks struct {
	DS               *mocks.VerifierAPI
	PushyPublisher   *mocks.Publisher
	SuccessPublisher *mocks.Publisher
	User             *mocks.UserWrapper
}

func (m *Mocks) Init() {
	m.DS = &mocks.VerifierAPI{}
	m.PushyPublisher = &mocks.Publisher{}
	m.SuccessPublisher = &mocks.Publisher{}
	m.User = &mocks.UserWrapper{}
}

func (m *Mocks) AssertExpectations(t *testing.T) {
	m.DS.AssertExpectations(t)
	m.PushyPublisher.AssertExpectations(t)
	m.SuccessPublisher.AssertExpectations(t)
	m.User.AssertExpectations(t)
}

func (m *Mocks) Clients() *server.Clients {
	return &server.Clients{
		DS:                  m.DS,
		PushySNSPublisher:   m.PushyPublisher,
		SuccessSNSPublisher: m.SuccessPublisher,
	}
}
