// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchExtensionsXenonTwirp/twirp.proto

/*
Package TwitchExtensionsXenonTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchExtensionsXenonTwirp/twirp.proto
*/
package TwitchExtensionsXenonTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===============================
// TwitchExtensionsXenon Interface
// ===============================

type TwitchExtensionsXenon interface {
	GetExtensionsByChannelID(context.Context, *GetExtensionsByChannelIDRequest) (*GetExtensionsByChannelIDResponse, error)

	GetMobileExtensionInstallationByID(context.Context, *GetMobileExtensionInstallationByIDRequest) (*GetMobileExtensionInstallationByIDResponse, error)

	PublishMessage(context.Context, *PublishMessageRequest) (*PublishMessageResponse, error)

	GetLinkedExtensions(context.Context, *GetLinkedExtensionsRequest) (*GetLinkedExtensionsResponse, error)

	CompareGetExtensionsByChannelID(context.Context, *CompareGetExtensionsByChannelIDRequest) (*google_protobuf.Empty, error)
}

// =====================================
// TwitchExtensionsXenon Protobuf Client
// =====================================

type twitchExtensionsXenonProtobufClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewTwitchExtensionsXenonProtobufClient creates a Protobuf client that implements the TwitchExtensionsXenon interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchExtensionsXenonProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchExtensionsXenon {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchExtensionsXenonPathPrefix
	urls := [5]string{
		prefix + "GetExtensionsByChannelID",
		prefix + "GetMobileExtensionInstallationByID",
		prefix + "PublishMessage",
		prefix + "GetLinkedExtensions",
		prefix + "CompareGetExtensionsByChannelID",
	}

	return &twitchExtensionsXenonProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchExtensionsXenonProtobufClient) GetExtensionsByChannelID(ctx context.Context, in *GetExtensionsByChannelIDRequest) (*GetExtensionsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionsByChannelID")
	out := new(GetExtensionsByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonProtobufClient) GetMobileExtensionInstallationByID(ctx context.Context, in *GetMobileExtensionInstallationByIDRequest) (*GetMobileExtensionInstallationByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetMobileExtensionInstallationByID")
	out := new(GetMobileExtensionInstallationByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonProtobufClient) PublishMessage(ctx context.Context, in *PublishMessageRequest) (*PublishMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "PublishMessage")
	out := new(PublishMessageResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonProtobufClient) GetLinkedExtensions(ctx context.Context, in *GetLinkedExtensionsRequest) (*GetLinkedExtensionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkedExtensions")
	out := new(GetLinkedExtensionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonProtobufClient) CompareGetExtensionsByChannelID(ctx context.Context, in *CompareGetExtensionsByChannelIDRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "CompareGetExtensionsByChannelID")
	out := new(google_protobuf.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchExtensionsXenon JSON Client
// =================================

type twitchExtensionsXenonJSONClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewTwitchExtensionsXenonJSONClient creates a JSON client that implements the TwitchExtensionsXenon interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchExtensionsXenonJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchExtensionsXenon {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchExtensionsXenonPathPrefix
	urls := [5]string{
		prefix + "GetExtensionsByChannelID",
		prefix + "GetMobileExtensionInstallationByID",
		prefix + "PublishMessage",
		prefix + "GetLinkedExtensions",
		prefix + "CompareGetExtensionsByChannelID",
	}

	return &twitchExtensionsXenonJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchExtensionsXenonJSONClient) GetExtensionsByChannelID(ctx context.Context, in *GetExtensionsByChannelIDRequest) (*GetExtensionsByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionsByChannelID")
	out := new(GetExtensionsByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonJSONClient) GetMobileExtensionInstallationByID(ctx context.Context, in *GetMobileExtensionInstallationByIDRequest) (*GetMobileExtensionInstallationByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetMobileExtensionInstallationByID")
	out := new(GetMobileExtensionInstallationByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonJSONClient) PublishMessage(ctx context.Context, in *PublishMessageRequest) (*PublishMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "PublishMessage")
	out := new(PublishMessageResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonJSONClient) GetLinkedExtensions(ctx context.Context, in *GetLinkedExtensionsRequest) (*GetLinkedExtensionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkedExtensions")
	out := new(GetLinkedExtensionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchExtensionsXenonJSONClient) CompareGetExtensionsByChannelID(ctx context.Context, in *CompareGetExtensionsByChannelIDRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithMethodName(ctx, "CompareGetExtensionsByChannelID")
	out := new(google_protobuf.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// TwitchExtensionsXenon Server Handler
// ====================================

type twitchExtensionsXenonServer struct {
	TwitchExtensionsXenon
	hooks *twirp.ServerHooks
}

func NewTwitchExtensionsXenonServer(svc TwitchExtensionsXenon, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchExtensionsXenonServer{
		TwitchExtensionsXenon: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchExtensionsXenonServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchExtensionsXenonPathPrefix is used for all URL paths on a twirp TwitchExtensionsXenon server.
// Requests are always: POST TwitchExtensionsXenonPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchExtensionsXenonPathPrefix = "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/"

func (s *twitchExtensionsXenonServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchextensionsxenon")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchExtensionsXenon")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/GetExtensionsByChannelID":
		s.serveGetExtensionsByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/GetMobileExtensionInstallationByID":
		s.serveGetMobileExtensionInstallationByID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/PublishMessage":
		s.servePublishMessage(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/GetLinkedExtensions":
		s.serveGetLinkedExtensions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchextensionsxenon.TwitchExtensionsXenon/CompareGetExtensionsByChannelID":
		s.serveCompareGetExtensionsByChannelID(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchExtensionsXenonServer) serveGetExtensionsByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExtensionsByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExtensionsByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchExtensionsXenonServer) serveGetExtensionsByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetExtensionsByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetExtensionsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetExtensionsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionsByChannelIDResponse and nil error while calling GetExtensionsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveGetExtensionsByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExtensionsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetExtensionsByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetExtensionsByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetExtensionsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExtensionsByChannelIDResponse and nil error while calling GetExtensionsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveGetMobileExtensionInstallationByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetMobileExtensionInstallationByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetMobileExtensionInstallationByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchExtensionsXenonServer) serveGetMobileExtensionInstallationByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMobileExtensionInstallationByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetMobileExtensionInstallationByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetMobileExtensionInstallationByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetMobileExtensionInstallationByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetMobileExtensionInstallationByIDResponse and nil error while calling GetMobileExtensionInstallationByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveGetMobileExtensionInstallationByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMobileExtensionInstallationByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetMobileExtensionInstallationByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetMobileExtensionInstallationByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetMobileExtensionInstallationByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetMobileExtensionInstallationByIDResponse and nil error while calling GetMobileExtensionInstallationByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) servePublishMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchExtensionsXenonServer) servePublishMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublishMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishMessageResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.PublishMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishMessageResponse and nil error while calling PublishMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) servePublishMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PublishMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishMessageResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.PublishMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishMessageResponse and nil error while calling PublishMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveGetLinkedExtensions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLinkedExtensionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLinkedExtensionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchExtensionsXenonServer) serveGetLinkedExtensionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkedExtensions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLinkedExtensionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLinkedExtensionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetLinkedExtensions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLinkedExtensionsResponse and nil error while calling GetLinkedExtensions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveGetLinkedExtensionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLinkedExtensions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetLinkedExtensionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLinkedExtensionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.GetLinkedExtensions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLinkedExtensionsResponse and nil error while calling GetLinkedExtensions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveCompareGetExtensionsByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCompareGetExtensionsByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCompareGetExtensionsByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchExtensionsXenonServer) serveCompareGetExtensionsByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CompareGetExtensionsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CompareGetExtensionsByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.CompareGetExtensionsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling CompareGetExtensionsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) serveCompareGetExtensionsByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CompareGetExtensionsByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CompareGetExtensionsByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchExtensionsXenon.CompareGetExtensionsByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling CompareGetExtensionsByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchExtensionsXenonServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchExtensionsXenonServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchExtensionsXenonServer) PathPrefix() string {
	return TwitchExtensionsXenonPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2641 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0xcf, 0x73, 0x1b, 0x49,
	0xf5, 0xff, 0x8e, 0xfc, 0x4b, 0x7a, 0xb2, 0xbd, 0x49, 0x27, 0xf1, 0x4e, 0x94, 0x6c, 0xe2, 0x9d,
	0xcd, 0x77, 0xcb, 0x6c, 0x51, 0xf2, 0xae, 0xd9, 0xda, 0x1f, 0xc9, 0x42, 0x22, 0x5b, 0x8e, 0x23,
	0xd6, 0x49, 0xcc, 0xd8, 0xce, 0xaf, 0x03, 0xd0, 0x1e, 0xbd, 0x48, 0x43, 0x46, 0x33, 0x62, 0xa6,
	0xe5, 0x58, 0x70, 0x82, 0xc3, 0x16, 0xa9, 0xdd, 0x82, 0x4a, 0xc1, 0x81, 0x03, 0x1c, 0xe0, 0x02,
	0x9c, 0xb9, 0x00, 0x47, 0xaa, 0xf8, 0x03, 0xa8, 0xe2, 0x5f, 0xe1, 0x4e, 0xf5, 0x8f, 0x19, 0xf5,
	0x48, 0x23, 0x59, 0x72, 0x5c, 0x95, 0xda, 0x4b, 0xa2, 0x7e, 0xdd, 0xef, 0xd3, 0xaf, 0xfb, 0xfd,
	0xec, 0x37, 0x86, 0xeb, 0x4e, 0x50, 0xc7, 0xf2, 0x8f, 0x3a, 0x11, 0x73, 0xfd, 0x32, 0x3b, 0x5c,
	0xa5, 0xad, 0x9f, 0xf8, 0xab, 0x7b, 0xcf, 0x5d, 0xe6, 0x34, 0x37, 0x8f, 0x18, 0xfa, 0x91, 0x1b,
	0xf8, 0xd1, 0x23, 0xf4, 0x03, 0x7f, 0xef, 0xb9, 0x1b, 0xb6, 0x57, 0x19, 0xff, 0xb7, 0xdc, 0x0e,
	0x03, 0x16, 0x90, 0x77, 0x98, 0x58, 0x57, 0x7e, 0xda, 0xf1, 0x58, 0xe0, 0x97, 0xe5, 0x08, 0x13,
	0xae, 0x23, 0xce, 0x55, 0xba, 0xd4, 0x08, 0x82, 0x86, 0x87, 0xab, 0x82, 0xe5, 0xa0, 0xf3, 0x74,
	0x15, 0x5b, 0x6d, 0xd6, 0x95, 0x08, 0xa5, 0xab, 0xfd, 0x93, 0xcc, 0x6d, 0x61, 0xc4, 0x68, 0x4b,
	0x6d, 0x61, 0xfd, 0xd7, 0x00, 0x52, 0xf3, 0x23, 0x46, 0x3d, 0x0f, 0xeb, 0x89, 0x40, 0x64, 0x1b,
	0x0a, 0xc9, 0xc0, 0x34, 0x96, 0x8d, 0x95, 0xe2, 0x5a, 0xb9, 0x3c, 0x86, 0x34, 0xe5, 0x84, 0xcb,
	0xee, 0x01, 0x90, 0x46, 0xb2, 0x07, 0x65, 0x6e, 0xe0, 0xef, 0x32, 0xca, 0x3a, 0x91, 0x99, 0x13,
	0xb0, 0x1f, 0x8f, 0x05, 0x3b, 0xc8, 0x6e, 0x67, 0x40, 0x92, 0x15, 0x78, 0xc3, 0xc6, 0x1f, 0x77,
	0xdc, 0x10, 0xeb, 0x15, 0x87, 0xd3, 0x23, 0x73, 0x6a, 0x79, 0x6a, 0xa5, 0x60, 0xf7, 0x93, 0xad,
	0x5f, 0x5f, 0xd6, 0x4e, 0x48, 0x96, 0x60, 0xb6, 0xe2, 0x3b, 0xcd, 0x20, 0x14, 0x67, 0x2d, 0xd8,
	0x6a, 0x44, 0x2e, 0x43, 0xa1, 0x12, 0x45, 0xc8, 0xf6, 0xed, 0x6d, 0x2e, 0x2f, 0x47, 0xea, 0x11,
	0xc8, 0x15, 0x80, 0x4a, 0x87, 0x35, 0x83, 0xf0, 0x1e, 0x6d, 0xa1, 0x39, 0x25, 0x38, 0x35, 0x0a,
	0x31, 0x61, 0x6e, 0x9d, 0x46, 0xb8, 0x6f, 0xd7, 0xcc, 0x69, 0x31, 0x19, 0x0f, 0xc9, 0x32, 0x14,
	0xd7, 0x5d, 0x16, 0x6d, 0xfa, 0xf4, 0xc0, 0xc3, 0xba, 0x39, 0xb3, 0x6c, 0xac, 0xe4, 0x6d, 0x9d,
	0x44, 0xde, 0x83, 0x33, 0x7c, 0xb8, 0xdb, 0x69, 0xb7, 0x83, 0x90, 0x6d, 0xe3, 0x21, 0x7a, 0xe6,
	0xac, 0x00, 0x19, 0xa0, 0x73, 0x39, 0x36, 0x28, 0xc3, 0x46, 0x10, 0xba, 0x18, 0x99, 0x73, 0x42,
	0x4c, 0x8d, 0x22, 0xe7, 0x7d, 0x75, 0x5d, 0x66, 0x5e, 0x6c, 0xa6, 0x51, 0xc8, 0x87, 0x70, 0x61,
	0x23, 0xf0, 0x9f, 0xba, 0x8d, 0x4e, 0x28, 0x2e, 0x73, 0x3b, 0x70, 0xc4, 0xff, 0x66, 0x41, 0x6c,
	0x98, 0x3d, 0xc9, 0xcf, 0x50, 0xc5, 0xc8, 0x09, 0xdd, 0xb6, 0x58, 0x0b, 0x62, 0xad, 0x4e, 0xe2,
	0xfb, 0x6e, 0xee, 0x6f, 0x57, 0xf6, 0xee, 0xef, 0xee, 0xdb, 0xdb, 0x66, 0x51, 0xde, 0x4f, 0x8f,
	0x42, 0xce, 0xc3, 0xcc, 0x16, 0x6d, 0x61, 0x64, 0xce, 0x2f, 0x4f, 0xad, 0xcc, 0xd8, 0x72, 0x40,
	0xde, 0x87, 0x73, 0x1b, 0x81, 0xcf, 0xd0, 0x67, 0x77, 0x29, 0xb7, 0x84, 0xba, 0x5c, 0xb3, 0x20,
	0xd6, 0x64, 0x4d, 0x91, 0x77, 0x61, 0xf1, 0x0e, 0x8d, 0x36, 0x9a, 0x94, 0xa9, 0x6b, 0x31, 0x17,
	0xc5, 0x19, 0xfb, 0xa8, 0xe4, 0x11, 0xe4, 0x6b, 0x4e, 0xe0, 0x0b, 0x65, 0xbe, 0xb1, 0x3c, 0xb5,
	0x52, 0x5c, 0xfb, 0x6c, 0x32, 0x9b, 0x2e, 0xc7, 0xec, 0x9b, 0x3e, 0x0b, 0xbb, 0x76, 0x82, 0x46,
	0x16, 0x21, 0x57, 0xab, 0x9a, 0x67, 0xc4, 0x09, 0x73, 0xb5, 0x2a, 0x21, 0x30, 0x2d, 0x6c, 0xe2,
	0xac, 0xa0, 0x88, 0xdf, 0x5c, 0xa3, 0x3b, 0xa1, 0x7b, 0x48, 0x9d, 0xee, 0x4e, 0xe0, 0xb9, 0x4e,
	0x97, 0xdf, 0x09, 0x91, 0x1a, 0xed, 0xa7, 0xf3, 0x3b, 0xe0, 0x06, 0x8b, 0x11, 0xab, 0xd5, 0xd1,
	0x67, 0x2e, 0xeb, 0x6e, 0xbb, 0xfe, 0x33, 0xf3, 0x9c, 0x38, 0x56, 0xd6, 0x14, 0x59, 0x87, 0xcb,
	0xb1, 0x89, 0xaf, 0x87, 0x01, 0xad, 0x3b, 0x34, 0x62, 0x18, 0x56, 0x0e, 0x5c, 0xcf, 0x65, 0xdc,
	0x2a, 0xce, 0x0b, 0xab, 0x18, 0xb9, 0x86, 0xdb, 0x41, 0x3c, 0x9f, 0x52, 0xb9, 0x79, 0x41, 0xda,
	0x41, 0xe6, 0x24, 0xbf, 0xfd, 0x5d, 0x27, 0x44, 0xf4, 0xa3, 0x66, 0x20, 0x1d, 0x65, 0x49, 0xec,
	0xd5, 0x47, 0x25, 0x67, 0x60, 0x6a, 0xf7, 0xf3, 0x7d, 0xf3, 0x4d, 0x81, 0xc5, 0x7f, 0x72, 0xfd,
	0x73, 0xbf, 0x45, 0xd3, 0x14, 0x34, 0x39, 0x20, 0x9f, 0xc1, 0xc5, 0xdd, 0xce, 0x41, 0x62, 0x45,
	0x69, 0x17, 0xb8, 0x28, 0x56, 0x0e, 0x5f, 0xc0, 0x7d, 0x6e, 0xb7, 0xd3, 0x6a, 0xd1, 0xb0, 0x6b,
	0x96, 0xa4, 0xcf, 0xa9, 0x21, 0xb1, 0x60, 0x5e, 0xad, 0xdc, 0x6c, 0x51, 0xd7, 0x33, 0x2f, 0x89,
	0xe9, 0x14, 0x8d, 0x5b, 0xec, 0x03, 0xf4, 0xeb, 0x41, 0xb8, 0x11, 0xd4, 0xd1, 0xbc, 0x2c, 0x2d,
	0xb6, 0x47, 0xe1, 0xe8, 0x0f, 0x30, 0x14, 0x41, 0xf1, 0x2d, 0x89, 0xae, 0x86, 0xe4, 0x1a, 0x2c,
	0x3c, 0x70, 0xf1, 0x39, 0x86, 0xf1, 0xee, 0x57, 0xc4, 0x7c, 0x9a, 0x48, 0x76, 0x61, 0x86, 0x13,
	0x22, 0xf3, 0xaa, 0x88, 0x7d, 0xdf, 0x9e, 0xd0, 0xfc, 0x92, 0x5f, 0x02, 0xc4, 0x96, 0x58, 0x5c,
	0x6d, 0x0f, 0x9b, 0x2e, 0x43, 0xcf, 0x8d, 0x58, 0xac, 0x1c, 0xa1, 0x87, 0x65, 0xa1, 0x87, 0xec,
	0x49, 0xb2, 0x06, 0xe7, 0xb5, 0x89, 0x1d, 0xea, 0xa3, 0x27, 0x98, 0xde, 0x16, 0x4c, 0x99, 0x73,
	0xe4, 0x23, 0x58, 0xda, 0x08, 0x7c, 0x1f, 0x1d, 0x56, 0x0d, 0x5a, 0xd4, 0xf5, 0x2b, 0x9e, 0x17,
	0x3c, 0xe7, 0x8b, 0x4c, 0x4b, 0x70, 0x0d, 0x99, 0xe5, 0x7b, 0xd5, 0x5a, 0xb4, 0x81, 0xfd, 0x5c,
	0xef, 0xc8, 0xbd, 0xb2, 0xe6, 0x38, 0xcf, 0x5d, 0xac, 0xbb, 0xb4, 0x9f, 0xe7, 0x9a, 0xe4, 0xc9,
	0x9a, 0x2b, 0xdd, 0x80, 0x85, 0x94, 0x87, 0x72, 0x9b, 0x7b, 0x86, 0x5d, 0x15, 0xd4, 0xf9, 0x4f,
	0x6e, 0x73, 0x87, 0xd4, 0xeb, 0xa0, 0xc8, 0x3e, 0x05, 0x5b, 0x0e, 0xae, 0xe7, 0x3e, 0x31, 0x4a,
	0xbf, 0x31, 0x00, 0xa4, 0xb6, 0xc4, 0x59, 0x97, 0x60, 0xf6, 0x6e, 0x70, 0xe0, 0x7a, 0x18, 0xa7,
	0x04, 0x39, 0xe2, 0x00, 0xe2, 0x42, 0x62, 0x00, 0x31, 0xe0, 0xc6, 0xf5, 0xc0, 0xad, 0x63, 0x70,
	0xff, 0x10, 0x43, 0x8f, 0x76, 0x55, 0x32, 0x48, 0xd1, 0x78, 0x32, 0xd9, 0x08, 0x5a, 0xed, 0xc0,
	0x47, 0x9f, 0xa9, 0x84, 0xd0, 0x23, 0xf0, 0xfd, 0xee, 0xb8, 0xf5, 0x3a, 0xfa, 0x22, 0x1b, 0x14,
	0x6c, 0x35, 0x2a, 0xfd, 0x6d, 0x06, 0x16, 0xd3, 0x7a, 0x27, 0x4f, 0x52, 0xa2, 0x15, 0xd7, 0xd6,
	0x27, 0x34, 0x23, 0xc9, 0x9c, 0x02, 0x4d, 0x8e, 0xf7, 0x50, 0x3f, 0x5e, 0x71, 0xad, 0x32, 0x21,
	0xb4, 0xe0, 0x4d, 0x23, 0xab, 0x1b, 0xf2, 0x32, 0x6e, 0xa8, 0xb8, 0x76, 0x67, 0x42, 0x7c, 0x1d,
	0x22, 0xbd, 0x4d, 0xfa, 0xae, 0x9d, 0xfe, 0xbb, 0x2e, 0xae, 0x6d, 0x4e, 0xb8, 0x55, 0xc2, 0x9f,
	0xde, 0x47, 0x53, 0xd9, 0x93, 0x94, 0xca, 0x26, 0xd7, 0x83, 0x64, 0xee, 0xd3, 0x83, 0x24, 0x72,
	0x6c, 0xe9, 0xac, 0x22, 0xeb, 0x4f, 0x8e, 0x2d, 0x99, 0xfb, 0xb0, 0x25, 0x91, 0x3c, 0x05, 0xd8,
	0x76, 0x0f, 0x51, 0xe1, 0xcf, 0x09, 0xfc, 0xdb, 0x13, 0xe2, 0xf7, 0x00, 0xd2, 0x7b, 0x68, 0xc8,
	0xa5, 0x2f, 0x0d, 0x38, 0x97, 0x61, 0x6b, 0x22, 0x8c, 0x50, 0x9f, 0xa7, 0x2d, 0x4e, 0x0f, 0x7d,
	0xea, 0xa9, 0xac, 0x2e, 0xec, 0x39, 0x6f, 0x0f, 0x99, 0x15, 0xd1, 0x59, 0x38, 0xe8, 0x0e, 0x65,
	0x4d, 0xe5, 0x7f, 0x1a, 0x85, 0x3b, 0x58, 0xe2, 0xc0, 0xca, 0x03, 0x7b, 0x84, 0xd2, 0x1f, 0x0d,
	0x20, 0x83, 0xe6, 0x79, 0x62, 0x61, 0xb8, 0xbf, 0xa2, 0xdb, 0x68, 0x32, 0x21, 0xc8, 0x8c, 0xad,
	0x46, 0x7d, 0x42, 0x4e, 0x8d, 0x16, 0x72, 0xba, 0x5f, 0xc8, 0x97, 0x06, 0x5c, 0x1c, 0x6a, 0xe3,
	0xaf, 0xe9, 0xe2, 0xfe, 0x91, 0xe3, 0x61, 0x3f, 0xcb, 0x19, 0x5e, 0x8f, 0x40, 0x3c, 0xd8, 0x56,
	0xa2, 0x36, 0x3a, 0xcc, 0xe6, 0x15, 0xc8, 0x23, 0x71, 0x8b, 0x33, 0x76, 0x8a, 0xd6, 0xb7, 0xe6,
	0xb1, 0xf0, 0xd0, 0xf4, 0x9a, 0xc7, 0xa2, 0xba, 0xef, 0xb0, 0x20, 0x72, 0xa8, 0x87, 0xc2, 0xcd,
	0xf2, 0x76, 0x8f, 0xc0, 0xeb, 0xdb, 0x5d, 0xfe, 0x63, 0xc7, 0x3d, 0x42, 0x2f, 0x12, 0x6e, 0x32,
	0x63, 0xeb, 0x24, 0xbe, 0xc7, 0x1e, 0x0d, 0x1b, 0xc8, 0x94, 0x21, 0xe4, 0xe5, 0x1e, 0x3a, 0x4d,
	0xf8, 0x40, 0x86, 0x9f, 0xbf, 0x26, 0x55, 0x72, 0x69, 0x32, 0xbc, 0xf6, 0x35, 0x49, 0xf3, 0x2b,
	0x03, 0xde, 0x1c, 0x12, 0x47, 0x5e, 0x8f, 0x44, 0xd6, 0x5f, 0x0c, 0xb8, 0xa0, 0x3f, 0x2b, 0x7b,
	0xb5, 0xf1, 0x35, 0x58, 0xa8, 0x89, 0xc7, 0x44, 0xfc, 0x66, 0x93, 0x62, 0xa4, 0x89, 0x72, 0x95,
	0xfe, 0xb2, 0xcb, 0xc5, 0xab, 0xf4, 0xb7, 0x5d, 0x15, 0xde, 0xaa, 0x45, 0x7a, 0x09, 0x2b, 0x5f,
	0xaf, 0x95, 0x43, 0xea, 0x7a, 0x7c, 0x85, 0x90, 0x2b, 0x6f, 0x8f, 0x5e, 0x64, 0xbd, 0xc8, 0xc1,
	0xf9, 0xdb, 0x48, 0x59, 0x27, 0xc4, 0xdb, 0x1e, 0x6d, 0x44, 0xd5, 0xc0, 0xe9, 0xb4, 0xf8, 0x15,
	0x2c, 0x43, 0x71, 0x83, 0xfa, 0xbb, 0xe8, 0xd7, 0xb9, 0x68, 0x4a, 0x50, 0x9d, 0xa4, 0x1e, 0x84,
	0xfb, 0x11, 0x72, 0xa9, 0x94, 0x8c, 0x1a, 0x85, 0x0b, 0xb8, 0x41, 0x7d, 0x1b, 0x59, 0xe8, 0xe2,
	0x21, 0x0e, 0x0a, 0x11, 0x0b, 0x38, 0x72, 0x11, 0x71, 0xe1, 0x6c, 0xb5, 0xeb, 0xd3, 0x96, 0xeb,
	0xdc, 0xa5, 0x3e, 0x6d, 0x60, 0x4b, 0xe6, 0x62, 0xfe, 0xee, 0xba, 0x31, 0x56, 0xb6, 0x19, 0xe0,
	0xde, 0xa1, 0x21, 0x6d, 0xd9, 0x83, 0xa8, 0xd6, 0xcb, 0xd9, 0xac, 0x0e, 0x03, 0x79, 0x04, 0x85,
	0xde, 0x0b, 0x48, 0xd6, 0x4a, 0xd7, 0x27, 0x6e, 0x37, 0x24, 0x08, 0x76, 0x0f, 0x8c, 0xac, 0xc0,
	0x1b, 0x15, 0x87, 0xb9, 0x87, 0xc9, 0x6e, 0x71, 0x41, 0xd9, 0x4f, 0x56, 0xda, 0x50, 0xd4, 0x58,
	0xb5, 0x3a, 0x49, 0x3d, 0x1e, 0xa7, 0x93, 0xc7, 0x63, 0x03, 0xce, 0xee, 0x60, 0xd8, 0x72, 0x19,
	0xc3, 0xba, 0x52, 0x70, 0xa4, 0x2a, 0x8c, 0x4f, 0xc7, 0x92, 0x3e, 0xcb, 0x2a, 0xec, 0x41, 0x4c,
	0xb2, 0x07, 0xd3, 0x7e, 0xc7, 0xf3, 0x54, 0x85, 0xf1, 0x9d, 0xb1, 0xb0, 0xef, 0x75, 0x3c, 0x4f,
	0x36, 0x47, 0x7a, 0x07, 0x15, 0x6a, 0xb9, 0xf3, 0x7f, 0xb6, 0x40, 0xe3, 0xa5, 0x97, 0x93, 0x94,
	0x5e, 0xb2, 0xb8, 0xd8, 0x18, 0x0b, 0x3a, 0xc9, 0x31, 0xc3, 0xf0, 0x7b, 0xb8, 0xe4, 0x00, 0xe6,
	0x02, 0x55, 0x48, 0xe6, 0x27, 0xa8, 0x5f, 0xf4, 0xd4, 0x3a, 0x6c, 0x97, 0x18, 0x98, 0x97, 0xc2,
	0x6d, 0x51, 0x0a, 0x17, 0xc4, 0x0e, 0x37, 0xc7, 0xda, 0x41, 0x54, 0x18, 0xc3, 0xa0, 0x25, 0x1e,
	0xaf, 0xed, 0x9a, 0xb2, 0x6e, 0x04, 0x81, 0x7c, 0x6b, 0x2c, 0x64, 0x99, 0x45, 0x86, 0x41, 0x2b,
	0xc4, 0xf5, 0x7c, 0xdc, 0xc9, 0xb2, 0x56, 0xe1, 0xe2, 0x50, 0x65, 0x11, 0x02, 0xd3, 0x91, 0x17,
	0x30, 0xf5, 0xb6, 0x11, 0xbf, 0xad, 0x1d, 0xb8, 0x32, 0x5a, 0x05, 0x59, 0x5c, 0x64, 0x1e, 0x8c,
	0x23, 0x55, 0x02, 0x19, 0x47, 0x7c, 0x24, 0x4b, 0xfb, 0x19, 0xdb, 0xe8, 0x5a, 0x1f, 0xc3, 0xdb,
	0xc7, 0xde, 0x78, 0xa6, 0x28, 0xef, 0x43, 0x69, 0xf8, 0x45, 0x66, 0x72, 0x7c, 0x00, 0x97, 0x46,
	0x5c, 0x50, 0x26, 0xcb, 0x3d, 0x58, 0xca, 0x8e, 0x30, 0xbc, 0xb6, 0x6b, 0xd0, 0x16, 0xd6, 0xaa,
	0x62, 0xfd, 0x8c, 0xad, 0x46, 0x3c, 0x79, 0xb8, 0x91, 0x5c, 0x1c, 0x87, 0xf6, 0x1e, 0xc1, 0x5a,
	0x87, 0x79, 0x99, 0xc9, 0x6c, 0x74, 0x82, 0xb0, 0x4e, 0x4c, 0x98, 0x73, 0xb4, 0x9c, 0x55, 0xb0,
	0xe3, 0x21, 0x9f, 0x39, 0x54, 0x6d, 0x04, 0x19, 0x35, 0xe2, 0xa1, 0xf5, 0x32, 0x07, 0x57, 0x92,
	0x44, 0x98, 0xea, 0xb3, 0x24, 0xe1, 0xfd, 0x3e, 0x14, 0xaa, 0x78, 0x88, 0x5e, 0xd0, 0xc6, 0x50,
	0x05, 0xb5, 0x0f, 0xc6, 0xf4, 0xaf, 0x9e, 0x70, 0x76, 0x0f, 0x83, 0xec, 0x42, 0x51, 0x6b, 0x07,
	0xa9, 0x87, 0xdf, 0x09, 0x20, 0x75, 0x14, 0x52, 0x83, 0xd9, 0x2d, 0x2f, 0x38, 0xa0, 0x9e, 0x7a,
	0xe8, 0x9d, 0x00, 0x4f, 0x01, 0x58, 0xbf, 0xcc, 0xc1, 0x9b, 0xc9, 0x9d, 0x88, 0x28, 0x16, 0xf1,
	0x5f, 0x55, 0xca, 0x28, 0x8f, 0xae, 0xc9, 0x94, 0x52, 0x57, 0xc1, 0xd6, 0x49, 0xfc, 0xbd, 0xbe,
	0x17, 0x3c, 0xc3, 0xf8, 0xa6, 0xe5, 0x80, 0xfc, 0x10, 0x66, 0xb7, 0x42, 0xea, 0x33, 0xd9, 0x1f,
	0x9e, 0xf8, 0x1d, 0x9a, 0x96, 0xa2, 0x2c, 0xa1, 0x64, 0x53, 0x50, 0xe1, 0xf2, 0x1c, 0x7b, 0x07,
	0x3d, 0xf7, 0x48, 0x6e, 0x2e, 0xa3, 0xbb, 0x46, 0x29, 0x7d, 0x0a, 0x45, 0x8d, 0xed, 0xb8, 0x4e,
	0x45, 0x5e, 0xeb, 0x54, 0x58, 0xbf, 0x30, 0xe0, 0xd2, 0x60, 0xcf, 0xbe, 0x57, 0x00, 0xb8, 0x70,
	0x2e, 0x63, 0xda, 0x34, 0xc4, 0x49, 0x27, 0xea, 0xb7, 0x6b, 0xfc, 0x76, 0x16, 0xa6, 0x15, 0xc1,
	0xd5, 0x2d, 0xec, 0x3d, 0x0a, 0xa2, 0xf5, 0xee, 0x46, 0x93, 0xfa, 0x3e, 0x7a, 0xb5, 0xaa, 0xea,
	0x52, 0x72, 0xa7, 0x71, 0x62, 0x9a, 0x3a, 0x5f, 0x8f, 0xc0, 0x5d, 0xad, 0x13, 0x61, 0x58, 0xab,
	0x2a, 0xfd, 0xa8, 0x11, 0x29, 0x41, 0xde, 0x8d, 0x54, 0x97, 0x43, 0xe6, 0xcc, 0x64, 0x6c, 0xfd,
	0x73, 0x1a, 0x96, 0x87, 0xef, 0x1a, 0xb5, 0x03, 0x3f, 0x42, 0xf2, 0x11, 0xe4, 0x6b, 0x51, 0xd4,
	0xc1, 0x7a, 0x85, 0x29, 0x2f, 0x29, 0x95, 0xe5, 0xc7, 0x90, 0x72, 0xfc, 0x31, 0xa4, 0xbc, 0x17,
	0x7f, 0x0c, 0xb1, 0x93, 0xb5, 0x64, 0x0f, 0x66, 0x85, 0x82, 0x64, 0xbf, 0x7f, 0xe2, 0x16, 0x71,
	0xda, 0x32, 0x6c, 0x85, 0x45, 0x7e, 0x3e, 0x5a, 0x65, 0xca, 0x49, 0x6e, 0x9d, 0x50, 0x37, 0xbd,
	0x2c, 0x3f, 0xd2, 0x2e, 0x7e, 0x66, 0xc0, 0x62, 0x2a, 0xa6, 0x44, 0xaa, 0x1c, 0x7b, 0x3c, 0xd6,
	0xbe, 0xc7, 0x5d, 0x79, 0x39, 0x8d, 0x2d, 0xdd, 0xa1, 0x6f, 0xc3, 0xd2, 0x17, 0xc9, 0x0b, 0x24,
	0xb5, 0x2e, 0xc3, 0xfe, 0x1f, 0xeb, 0xf6, 0x3f, 0x6e, 0x0d, 0x31, 0x3a, 0x76, 0xea, 0x4e, 0xf4,
	0x7b, 0x03, 0xbe, 0xb1, 0x85, 0xac, 0xaf, 0x3f, 0xa1, 0x17, 0x7e, 0xeb, 0xdd, 0x71, 0x8d, 0x78,
	0x19, 0x8a, 0xa8, 0x45, 0x21, 0x69, 0xc9, 0x3a, 0x49, 0x33, 0xf3, 0xa9, 0x94, 0x99, 0x6b, 0x99,
	0x60, 0x3a, 0x9d, 0x09, 0xbe, 0x9a, 0x82, 0xf7, 0xc6, 0x91, 0xef, 0x15, 0xcd, 0xdd, 0xd6, 0xc3,
	0xe3, 0xab, 0x5a, 0xbb, 0x0a, 0xae, 0x8d, 0xac, 0x4f, 0x8a, 0xca, 0xc4, 0x4f, 0x1c, 0x7e, 0xb2,
	0xbe, 0x52, 0xba, 0xb0, 0x90, 0xfe, 0x50, 0x31, 0x7d, 0x7a, 0xa6, 0x92, 0x46, 0xb6, 0xfe, 0x6d,
	0xc0, 0x85, 0x9d, 0xce, 0x81, 0xe7, 0x46, 0xcd, 0xbb, 0x18, 0x45, 0xb4, 0x81, 0xb1, 0x69, 0x98,
	0x30, 0xa7, 0x28, 0x71, 0x9a, 0x57, 0x43, 0x3e, 0x23, 0x7b, 0x01, 0xf1, 0xb7, 0xc3, 0x78, 0x48,
	0x2c, 0x98, 0xdf, 0x3c, 0x62, 0x95, 0x0e, 0x6b, 0xca, 0xcb, 0x57, 0xed, 0x62, 0x9d, 0x26, 0x1e,
	0x0e, 0xb2, 0x5e, 0xd8, 0xeb, 0xb6, 0x51, 0x99, 0x87, 0x4e, 0x12, 0x0d, 0xe5, 0xc4, 0x28, 0x67,
	0x54, 0x43, 0x59, 0x37, 0x4a, 0x3d, 0x35, 0xce, 0x0e, 0xa4, 0x46, 0xeb, 0x0f, 0x39, 0x78, 0x97,
	0x57, 0x7c, 0x34, 0xc4, 0xe3, 0x82, 0xf8, 0x4f, 0xe1, 0xcc, 0xe6, 0x51, 0x1b, 0x1d, 0x86, 0xf5,
	0xd8, 0xe4, 0x94, 0x99, 0xdd, 0x1f, 0xbb, 0xb6, 0xa7, 0x21, 0x7f, 0xb7, 0x1e, 0x17, 0x45, 0xec,
	0x81, 0x8d, 0xc8, 0xf7, 0x61, 0x4e, 0xc9, 0xa1, 0xac, 0xb4, 0xfa, 0x8a, 0xf1, 0x4a, 0x60, 0xd9,
	0x31, 0x28, 0xcf, 0x35, 0xb5, 0xbe, 0x5c, 0x13, 0x8f, 0xad, 0x3f, 0x4f, 0xc3, 0x7b, 0xe3, 0x0b,
	0xaf, 0x65, 0x0f, 0xe3, 0x14, 0xb3, 0xc7, 0x57, 0xc7, 0x64, 0x0f, 0x79, 0x2b, 0xdf, 0x9d, 0x50,
	0x13, 0x27, 0xce, 0x23, 0x5f, 0x0e, 0xe6, 0x11, 0x59, 0x45, 0x39, 0xa7, 0x6c, 0x0b, 0x5f, 0xaf,
	0x8c, 0xf2, 0x3b, 0x03, 0xfe, 0x7f, 0xac, 0xdb, 0x25, 0xd1, 0xa8, 0x02, 0xad, 0xf2, 0xca, 0x6a,
	0xcc, 0x2e, 0xd5, 0x5e, 0xe4, 0xe0, 0xf2, 0x28, 0x2e, 0xf2, 0x60, 0xf0, 0x6f, 0x3e, 0x3e, 0x99,
	0x50, 0x96, 0xaf, 0xcb, 0x5f, 0x7f, 0xdc, 0xe4, 0x26, 0x33, 0x20, 0xb4, 0xea, 0xc4, 0x18, 0x49,
	0x27, 0x46, 0xfb, 0xdc, 0x9b, 0x4b, 0x7d, 0xee, 0xb5, 0xfe, 0x63, 0xc0, 0xfc, 0x5e, 0x33, 0x0c,
	0x18, 0xf3, 0x50, 0x3c, 0x44, 0xf8, 0xde, 0x94, 0xe1, 0xb6, 0xdb, 0x72, 0x19, 0xca, 0x3f, 0x08,
	0x91, 0x38, 0xfd, 0x64, 0x9e, 0xa9, 0x6d, 0x8c, 0x90, 0x45, 0x95, 0xd8, 0x71, 0x47, 0x66, 0xea,
	0x78, 0x2d, 0xb9, 0x06, 0x0b, 0x02, 0x66, 0xf3, 0xc8, 0x41, 0xac, 0x63, 0x5d, 0x85, 0xaa, 0x34,
	0x91, 0xbc, 0x0b, 0x8b, 0x36, 0xb6, 0xa8, 0xeb, 0xbb, 0x7e, 0xe3, 0x7b, 0x9d, 0x80, 0x51, 0xd5,
	0x1d, 0xef, 0xa3, 0xf2, 0xd7, 0x85, 0x60, 0x54, 0x79, 0x43, 0x0e, 0xac, 0x2e, 0x2c, 0xf5, 0x27,
	0x39, 0x15, 0xd8, 0x7e, 0x00, 0x67, 0x93, 0x83, 0x44, 0x95, 0x76, 0xdb, 0x73, 0x45, 0x0f, 0x74,
	0x6a, 0xec, 0xa7, 0x9d, 0x7e, 0x5b, 0xf6, 0x20, 0x96, 0xf5, 0x21, 0x94, 0xb6, 0x90, 0x6d, 0xbb,
	0xfe, 0x33, 0xdd, 0x6a, 0xe3, 0x10, 0xdd, 0xab, 0x9f, 0x0c, 0xbd, 0x7e, 0xb2, 0x5a, 0x70, 0x29,
	0x93, 0x4b, 0x49, 0x7d, 0x0f, 0x60, 0xc0, 0xbf, 0x26, 0xfd, 0x3b, 0x26, 0x0d, 0xc1, 0xfa, 0xab,
	0x01, 0xdf, 0x3c, 0x26, 0x63, 0x3e, 0x0c, 0xc2, 0x67, 0x18, 0xc6, 0x25, 0x80, 0xfc, 0xc4, 0xa0,
	0xb2, 0xbc, 0xaa, 0x1b, 0x7b, 0x29, 0x1e, 0xfb, 0x13, 0xdb, 0xe7, 0x13, 0xf8, 0x1b, 0x8e, 0x9b,
	0xdf, 0xd6, 0xfe, 0x3e, 0x0b, 0x17, 0x32, 0xff, 0xe2, 0x8c, 0xfc, 0xc9, 0x00, 0x73, 0x18, 0x0c,
	0x39, 0x95, 0x2c, 0x5b, 0xda, 0x3c, 0x95, 0xb7, 0x05, 0xf9, 0x97, 0x01, 0xd6, 0xf1, 0xe5, 0x30,
	0xb9, 0x37, 0xee, 0x6e, 0xe3, 0xd5, 0xfd, 0xa5, 0xfb, 0xa7, 0x86, 0xa7, 0xce, 0xf1, 0xc2, 0x80,
	0xc5, 0xb4, 0x8b, 0x91, 0xf1, 0x5a, 0xd2, 0x99, 0xc5, 0x67, 0xe9, 0xc6, 0x89, 0x78, 0x95, 0x2c,
	0xbf, 0x35, 0xe0, 0x5c, 0x86, 0xf7, 0x90, 0x9b, 0xe3, 0x1e, 0x7a, 0x88, 0xb7, 0x96, 0x6e, 0x9d,
	0x1c, 0x40, 0x89, 0xf6, 0x85, 0x01, 0x57, 0x8f, 0x31, 0x73, 0x72, 0x9a, 0xce, 0x52, 0x5a, 0x1a,
	0x88, 0xc1, 0x9b, 0xad, 0x36, 0xeb, 0xae, 0xbf, 0xff, 0xa4, 0x3c, 0xd9, 0x1f, 0x70, 0x1e, 0xcc,
	0x0a, 0x84, 0x6f, 0xfd, 0x2f, 0x00, 0x00, 0xff, 0xff, 0xfe, 0xdd, 0x1b, 0xd2, 0xf9, 0x29, 0x00,
	0x00,
}
