package converters

import (
	serviceapi "code.justin.tv/amzn/TwitchExtensionsXenonTwirp"
	configservice "code.justin.tv/extensions/configuration/services/main/protocol"
)

type Configurations map[string]*serviceapi.ExtensionConfigurationDocument

func ConfigurationsToXenon(configsByExtension configservice.ConfigByExtension) Configurations {
	configTypes := [3]configservice.SegmentType{configservice.DeveloperType, configservice.BroadcasterType, configservice.GlobalType}
	configurations := make(Configurations)

	for extID, extConfig := range configsByExtension {
		configDocumentsByType := make(map[configservice.SegmentType]*serviceapi.ConfigRecord)

		for _, configType := range configTypes {
			configDocument := &serviceapi.ConfigRecord{}
			if configForType, ok := extConfig[configType]; ok {
				configDocument.Version = configForType.Version()

				content := configForType.Content()
				if content != nil {
					configDocument.Content = *content
				} else {
					configDocument.Content = ""
				}
			}

			configDocumentsByType[configType] = configDocument
		}

		configurations[extID] = &serviceapi.ExtensionConfigurationDocument{
			Developer:   configDocumentsByType[configservice.DeveloperType],
			Broadcaster: configDocumentsByType[configservice.BroadcasterType],
			Global:      configDocumentsByType[configservice.GlobalType],
		}
	}

	return configurations
}
