package util

import (
	"errors"
	"fmt"

	"google.golang.org/protobuf/types/known/anypb"

	fcontext "code.justin.tv/amzn/TwitchFeatureContext/schema/TwitchFeatureContext"
)

func MarshalMLFSContext(fc *fcontext.MLFSContext) (*anypb.Any, error) {
	marshaledFC, err := anypb.New(fc)
	if err != nil {
		return &anypb.Any{}, fmt.Errorf("Failed to marshal feature context: %w", err)
	}
	return marshaledFC, nil
}

func UnmarshalMLFSContext(fc *anypb.Any) (*fcontext.MLFSContext, error) {
	m := new(fcontext.MLFSContext)
	if err := fc.UnmarshalTo(m); err != nil {
		return &fcontext.MLFSContext{}, errors.New("Could not unmarshal MLFSContext: FeatureContext message did not contain type MLFSContext")
	}
	return m, nil
}
