package cache

import (
	"time"

	boundedCache "code.justin.tv/amzn/TwitchBoundedCache"
)

type Cache interface {
	Get(key string) (interface{}, bool)
	SetWithExpiration(key string, val interface{}, d time.Duration) bool
}

func NewTwitchBoundedCache(config boundedCache.Config) (boundedCache.Cache, error) {
	return boundedCache.NewCache(boundedCache.FillInDefault(config))
}
