package jitter

import (
	"math/rand"
	"time"
)

type JitterGenerator struct {
	rng *rand.Rand
}

func NewJitterGenerator() *JitterGenerator {
	return &JitterGenerator{
		rng: rand.New(rand.NewSource(time.Now().UnixNano())),
	}
}

// Jitter will return a duration that is between 0 and up to the duration that is passed in
func (j *JitterGenerator) Jitter(dur time.Duration) time.Duration {

	return time.Duration(float64(dur) * j.rng.Float64())
}
