package jitter_test

import (
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchFeatureStoreClient/jitter"
	"github.com/stretchr/testify/assert"
)

func TestJitterGenerator(t *testing.T) {
	generator := jitter.NewJitterGenerator()

	for i := 1; i < 1000; i++ {
		dur := time.Duration(float64(time.Second) * float64(i))

		jitter := generator.Jitter(dur)
		assert.GreaterOrEqual(t, int64(jitter), int64(0))
		assert.LessOrEqual(t, int64(jitter), int64(dur))
	}
}
