package metadata

import (
	"errors"

	"code.justin.tv/amzn/TwitchFeatureGo"
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"code.justin.tv/amzn/TwitchFeatureStoreClient/validations"
)

type intAllValuesValidationMetadata struct {
	IdentifierGetterImpl
	validations.IntAllValuesValidation
}

type floatAllValuesValidationMetadata struct {
	IdentifierGetterImpl
	validations.FloatAllValuesValidation
}

type stringAllValuesValidationMetadata struct {
	IdentifierGetterImpl
	validations.StringAllValuesValidation
}

var _ MetadataServicer = &stringAllValuesValidationMetadata{}

func AllValuesValidationServicer(id types.FeatureKey, validation *TwitchFeatureGo.Validation, valueType *TwitchFeatureGo.ValueType) (MetadataServicer, error) {
	if valueType == nil {
		return nil, errors.New("value type cannot be nil for validation")
	}

	// not yet supported
	if valueType.Shape != TwitchFeatureGo.ValueType_DATA_SHAPE_SCALAR {
		return &noOpValidationMetadata{IdentifierGetterImpl{id}, validations.UnsupportedValidation{}}, nil
	}

	switch valueType.Type {
	case TwitchFeatureGo.ValueType_DATA_TYPE_INTEGER:
		return &intAllValuesValidationMetadata{IdentifierGetterImpl{id}, validations.IntAllValuesValidation{Replacer: validations.NewReplacer(validation, valueType)}}, nil
	case TwitchFeatureGo.ValueType_DATA_TYPE_FLOAT:
		return &floatAllValuesValidationMetadata{IdentifierGetterImpl{id}, validations.FloatAllValuesValidation{
			Replacer: validations.NewReplacer(validation, valueType)}}, nil
	case TwitchFeatureGo.ValueType_DATA_TYPE_STRING:
		return &stringAllValuesValidationMetadata{IdentifierGetterImpl{id}, validations.StringAllValuesValidation{Replacer: validations.NewReplacer(validation, valueType)}}, nil
	}

	return NewNoOpValidationServicer(id), nil
}
