package metadata

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"reflect"
	"testing"

	"code.justin.tv/amzn/TwitchFeatureGo"
)

func TestAlllValuesStringGenerateMetadata(t *testing.T) {
	wrongType := &types.IntFeature{Val: 1}
	imdb := &types.StringFeature{Val: "imdb"}
	twitch := &types.StringFeature{Val: "twitch"}
	stringMetadata := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule: &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
		}, reflect.String)
	stringMetadataWithReplacement := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule:        &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
			Replacement: newProtobufStringValue("imdb")}, reflect.String)
	tests := []testCase{
		{
			name:  "string all values servicer",
			input: newToMetadataInput(stringMetadata),
			validaterTestCase: &validaterTest{
				value:         twitch,
				expected:      twitch,
				expectedError: false,
			},
		},
		{
			name:  "string set all values servicer replacement",
			input: newToMetadataInput(stringMetadataWithReplacement),
			validaterTestCase: &validaterTest{
				value:         wrongType,
				expected:      imdb,
				expectedError: false,
			},
		},
	}

	runGenerateMetadataTests(t, tests)
}

func TestAllValuesIntGenerateMetadata(t *testing.T) {
	oneStr := &types.StringFeature{Val: "1"}
	one := &types.IntFeature{Val: 1}
	two := &types.IntFeature{Val: 2}
	rawMetadata := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule: &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
		}, reflect.Int64)
	rawMetadataWithReplacement := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule:        &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
			Replacement: newProtobufIntValue(2),
		}, reflect.Int64)

	tests := []testCase{
		{
			name:              "validation success",
			input:             newToMetadataInput(rawMetadata),
			validaterTestCase: &validaterTest{value: one, expected: one, expectedError: false},
			expectedError:     false,
		},
		{
			name:              "validation replacement",
			input:             newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{value: oneStr, expected: two, expectedError: false},
			expectedError:     false,
		},
	}
	runGenerateMetadataTests(t, tests)
}

func TestAllValuesFloatGenerateMetadata(t *testing.T) {
	oneFiveSting := &types.StringFeature{Val: "1.5"}
	oneFive := &types.FloatFeature{Val: 1.5}
	twoFive := &types.FloatFeature{Val: 2.5}
	rawMetadata := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule: &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
		}, reflect.Float64)
	rawMetadataWithReplacement := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule:        &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
			Replacement: newProtobufFloatValue(2.5),
		}, reflect.Float64)
	tests := []testCase{
		{
			name:              "validation success",
			input:             newToMetadataInput(rawMetadata),
			validaterTestCase: &validaterTest{value: oneFive, expected: oneFive, expectedError: false},
			expectedError:     false,
		},
		{
			name:              "validation replacement",
			input:             newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{value: oneFiveSting, expected: twoFive, expectedError: false},
			expectedError:     false,
		},
	}
	runGenerateMetadataTests(t, tests)
}
