package metadata

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"reflect"
	"testing"

	"code.justin.tv/amzn/TwitchFeatureGo"
)

func TestAllowedRangeMetadataErrors(t *testing.T) {
	tests := []testCase{
		{
			name: "neither min nor max is set",
			input: newToMetadataInput(newProtobufMetdata(
				&TwitchFeatureGo.Validation{
					Rule: &TwitchFeatureGo.Validation_AllowedRange{
						AllowedRange: &TwitchFeatureGo.RangeValidation{},
					}}, reflect.Int64)),
			expectedError: true,
		},
	}

	runGenerateMetadataTests(t, tests)
}

func TestAllowedRangeFloatGenerateMetadata(t *testing.T) {
	oneOne := &types.FloatFeature{Val: 1.1}
	oneFive := &types.FloatFeature{Val: 1.5}
	twoFive := &types.FloatFeature{Val: 2.5}
	rawMetadata := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedRange{
			AllowedRange: &TwitchFeatureGo.RangeValidation{
				Max:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: 1.5}},
				MaxInclusive: false,
				Min:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: -1.5}},
				MinInclusive: false,
			},
		}}, reflect.Float64)
	rawMetadataWithReplacement := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedRange{
			AllowedRange: &TwitchFeatureGo.RangeValidation{
				Max:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: 1.5}},
				MaxInclusive: false,
				Min:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: -1.5}},
				MinInclusive: false,
			},
		}, Replacement: newProtobufFloatValue(2.5)}, reflect.Float64)

	tests := []testCase{
		{
			name:  "float range validation success",
			input: newToMetadataInput(rawMetadata),
			validaterTestCase: &validaterTest{
				value:    oneOne,
				expected: oneOne,
			},
			expectedError: false,
		},
		{
			name:  "float set replacement",
			input: newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{
				value:    oneFive,
				expected: twoFive,
			},
			expectedError: false,
		},
	}
	runGenerateMetadataTests(t, tests)
}

func TestAllowedRangeIntGenerateMetadata(t *testing.T) {
	zero := &types.IntFeature{Val: 0}
	one := &types.IntFeature{Val: 1}
	two := &types.IntFeature{Val: 2}

	rangeNonInclusiveValidation := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedRange{
			AllowedRange: &TwitchFeatureGo.RangeValidation{
				Max:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 1}},
				MaxInclusive: false,
				Min:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: -1}},
				MinInclusive: false,
			},
		}}, reflect.Int64)
	rawMetadataWithReplacement := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedRange{
			AllowedRange: &TwitchFeatureGo.RangeValidation{
				Max:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 1}},
				MaxInclusive: false,
				Min:          &TwitchFeatureGo.Value{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: -1}},
				MinInclusive: false,
			},
		}, Replacement: newProtobufIntValue(2)}, reflect.Int64)

	tests := []testCase{
		{
			name:              "range validation success",
			input:             newToMetadataInput(rangeNonInclusiveValidation),
			validaterTestCase: &validaterTest{value: zero, expected: zero},
			expectedError:     false,
		},
		{
			name:              "range validation replacement",
			input:             newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{value: one, expected: two},
		},
	}
	runGenerateMetadataTests(t, tests)
}
