package metadata

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"reflect"
	"testing"

	"code.justin.tv/amzn/TwitchFeatureGo"
)

func TestAllowedValuesMetadataErrors(t *testing.T) {
	tests := []testCase{
		{
			name: "0 allowed values",
			input: newToMetadataInput(newProtobufMetdata(
				&TwitchFeatureGo.Validation{
					Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{}}},
				}, reflect.Int64)),
			expectedError: true,
		},
	}

	runGenerateMetadataTests(t, tests)
}

func TestAllowedValuesStringGenerateMetadata(t *testing.T) {
	amazon := &types.StringFeature{Val: "amazon"}
	imdb := &types.StringFeature{Val: "imdb"}
	twitch := &types.StringFeature{Val: "twitch"}
	stringMetadata := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
				{Val: &TwitchFeatureGo.Value_StringVal{StringVal: "twitch"}}, {
					Val: &TwitchFeatureGo.Value_StringVal{StringVal: "whole_foods"},
				},
			}}},
		}, reflect.String)
	stringMetadataWithReplacement := newProtobufMetdata(
		&TwitchFeatureGo.Validation{
			Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
				{Val: &TwitchFeatureGo.Value_StringVal{StringVal: "twitch"}},
				{Val: &TwitchFeatureGo.Value_StringVal{StringVal: "whole_foods"}},
			}}},
			Replacement: newProtobufStringValue("imdb")}, reflect.String)

	tests := []testCase{
		{
			name:  "string set validation servicer",
			input: newToMetadataInput(stringMetadata),
			validaterTestCase: &validaterTest{
				value:         twitch,
				expected:      twitch,
				expectedError: false,
			},
		},
		{
			name:  "string set validation servicer replacement",
			input: newToMetadataInput(stringMetadataWithReplacement),
			validaterTestCase: &validaterTest{
				value:         amazon,
				expected:      imdb,
				expectedError: false,
			},
		},
	}

	runGenerateMetadataTests(t, tests)
}

func TestAllowedValuesIntGenerateMetadata(t *testing.T) {
	one := &types.IntFeature{Val: 1}
	two := &types.IntFeature{Val: 2}
	rawMetadata := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
			{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 1}},
			{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 0}},
		}}},
	}, reflect.Int64)
	rawMetadataWithReplacement := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
			{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 1}},
			{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 0}},
		}}},
		Replacement: newProtobufIntValue(2),
	}, reflect.Int64)

	tests := []testCase{
		{
			name:              "set validation success",
			input:             newToMetadataInput(rawMetadata),
			validaterTestCase: &validaterTest{value: one, expected: one, expectedError: false},
			expectedError:     false,
		},
		{
			name:              "set validation replacement",
			input:             newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{value: two, expected: two, expectedError: false},
			expectedError:     false,
		},
	}
	runGenerateMetadataTests(t, tests)
}

func TestAllowedValuesFloatGenerateMetadata(t *testing.T) {
	oneFive := &types.FloatFeature{Val: 1.5}
	twoZero := &types.FloatFeature{Val: 2.0}
	twoFive := &types.FloatFeature{Val: 2.5}
	rawMetadata := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
			{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: 1.5}}, {
				Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: -1.5},
			},
		}}},
	}, reflect.Float64)
	rawMetadataWithReplacement := newProtobufMetdata(&TwitchFeatureGo.Validation{
		Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
			{Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: 1.5}}, {
				Val: &TwitchFeatureGo.Value_FloatVal{FloatVal: -1.5},
			},
		}}},
		Replacement: newProtobufFloatValue(2.5),
	}, reflect.Float64)
	tests := []testCase{
		{
			name:              "float set validation success",
			input:             newToMetadataInput(rawMetadata),
			validaterTestCase: &validaterTest{value: oneFive, expected: oneFive, expectedError: false},
			expectedError:     false,
		},
		{
			name:              "float set validation replacement",
			input:             newToMetadataInput(rawMetadataWithReplacement),
			validaterTestCase: &validaterTest{value: twoZero, expected: twoFive, expectedError: false},
			expectedError:     false,
		},
	}
	runGenerateMetadataTests(t, tests)
}
