package metadata

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"testing"

	"code.justin.tv/amzn/TwitchFeatureGo"
)

func newProtobufMetadataWithType(validation *TwitchFeatureGo.Validation, valueType *TwitchFeatureGo.ValueType) *TwitchFeatureGo.FeatureMetadata {
	return &TwitchFeatureGo.FeatureMetadata{
		ValueType:  valueType,
		Validation: validation,
	}
}

func TestNoOpMetadataServicer(t *testing.T) {
	intFeature := &types.IntFeature{Val: 1}

	tests := []testCase{
		{
			name: "undefined value type no-ops",
			input: newToMetadataInput(newProtobufMetadataWithType(
				&TwitchFeatureGo.Validation{
					Replacement: nil,
					Rule:        &TwitchFeatureGo.Validation_AllValues{AllValues: &TwitchFeatureGo.NoValidation{}},
				},
				nil)),
			validaterTestCase: &validaterTest{
				value:    intFeature,
				expected: intFeature,
			},
			expectedError: false,
		}, {
			name: "non scalar value type no-ops; allows only zero but no-ops because of shape difference",
			input: newToMetadataInput(newProtobufMetadataWithType(
				&TwitchFeatureGo.Validation{
					Replacement: nil,
					Rule: &TwitchFeatureGo.Validation_AllowedValue{AllowedValue: &TwitchFeatureGo.SetValidation{Set: []*TwitchFeatureGo.Value{
						{Val: &TwitchFeatureGo.Value_IntegerVal{IntegerVal: 0}},
					}}}},
				&TwitchFeatureGo.ValueType{
					Type:  TwitchFeatureGo.ValueType_DATA_TYPE_INTEGER,
					Shape: TwitchFeatureGo.ValueType_DATA_SHAPE_BLOB,
				})),
			validaterTestCase: &validaterTest{
				value:    intFeature,
				expected: intFeature},
			expectedError: false,
		},
		{
			name: "no validation no-ops",
			input: newToMetadataInput(newProtobufMetadataWithType(
				nil,
				&TwitchFeatureGo.ValueType{
					Type:  TwitchFeatureGo.ValueType_DATA_TYPE_INTEGER,
					Shape: TwitchFeatureGo.ValueType_DATA_SHAPE_SCALAR,
				},
			)),
			validaterTestCase: &validaterTest{
				value:    intFeature,
				expected: intFeature},
			expectedError: false,
		},
	}

	runGenerateMetadataTests(t, tests)
}
