package metrics_test

import (
	"reflect"
	"testing"
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"

	"code.justin.tv/amzn/TwitchFeatureStoreClient/metrics"
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
)

type testObserver struct {
	ObserverdSample *telemetry.Sample
}

func (t *testObserver) ObserveSample(sample *telemetry.Sample) {
	t.ObserverdSample = sample
}

func (t *testObserver) Flush() {

}

func (t *testObserver) Stop() {

}

func Test_Reporter_Rollups(t *testing.T) {
	tests := []struct {
		name        string
		initializer func() *testObserver
		run         func(r metrics.Reporter)
	}{
		{
			name: "success_report_attempt",
			initializer: func() *testObserver {
				ob := &testObserver{}
				metrics.Initialize("test", "us-west-2", "test_stage", ob, nil)
				return ob
			},
			run: func(r metrics.Reporter) {
				r.ReportAttempt(1)
			},
		},
		{
			name: "success_report_latency",
			initializer: func() *testObserver {
				ob := &testObserver{}
				metrics.Initialize("test", "us-west-2", "test_stage", ob, nil)
				return ob
			},
			run: func(r metrics.Reporter) {
				r.ReportLatency(1 * time.Second)
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			testOb := tt.initializer()
			testKey := types.FeatureKey{
				FeatureID: "test_id",
				Namespace: "test",
				Version:   0,
			}
			testReporter := metrics.NewReporter(testKey)
			tt.run(testReporter)

			expectedRollups := [][]string{
				{metrics.DimensionFeature, telemetry.DimensionStage},
				{metrics.DimensionFeature, telemetry.DimensionService, telemetry.DimensionStage},
			}
			if !reflect.DeepEqual(testOb.ObserverdSample.RollupDimensions, expectedRollups) {
				t.Errorf("Rollups mismatch, got = %+v, want %+v", testOb.ObserverdSample.RollupDimensions, expectedRollups)
			}
		})
	}
}
