package types

import "time"

type FeatureParams struct {
	// the feature key of the feature
	FeatureKey FeatureKey
	// whether cache the feature
	CacheFeature bool
	// the ttl for the feature to live in the cache
	CacheTTL time.Duration
	// the jitter set on the ttl that the feature expires in [ttl, ttl+jitter] interval
	// the default jitter is 10 minutes
	FeatureJitter time.Duration
}
