package types_test

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"reflect"
	"testing"
)

func TestFeatureKey_AttributeKey(t *testing.T) {
	type fields struct {
		FeatureID string
		Namespace string
		Version   int32
	}
	tests := []struct {
		name   string
		fields fields
		want   string
	}{
		{
			name:   "success",
			fields: fields{FeatureID: "test_feature_1", Namespace: "test", Version: 10},
			want:   "test_feature_1@10",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			i := &types.FeatureKey{
				FeatureID: tt.fields.FeatureID,
				Namespace: tt.fields.Namespace,
				Version:   tt.fields.Version,
			}
			if got := i.AttributeKey(); got != tt.want {
				t.Errorf("AttributeKey() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestFeatureKey_GetPath(t *testing.T) {
	type fields struct {
		FeatureID string
		Namespace string
		Version   int32
	}
	tests := []struct {
		name   string
		fields fields
		want   string
	}{
		{
			name:   "success",
			fields: fields{FeatureID: "test_feature_1", Namespace: "test", Version: 10},
			want:   "test/test_feature_1/10/metadata",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			i := &types.FeatureKey{
				FeatureID: tt.fields.FeatureID,
				Namespace: tt.fields.Namespace,
				Version:   tt.fields.Version,
			}
			if got := i.GetPath(); got != tt.want {
				t.Errorf("GetPath() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestNewFeatureKey(t *testing.T) {
	type args struct {
		attributeKey string
		namespace    string
	}
	tests := []struct {
		name    string
		args    args
		want    types.FeatureKey
		wantErr bool
	}{
		{
			name: "success",
			args: args{
				attributeKey: "test_feature@0",
				namespace:    "test",
			},
			want: types.FeatureKey{
				FeatureID: "test_feature",
				Namespace: "test",
				Version:   0,
			},
		},
		{
			name: "fail - missing @",
			args: args{
				attributeKey: "test_feature1",
				namespace:    "test",
			},
			wantErr: true,
		},
		{
			name: "fail - multiple @",
			args: args{
				attributeKey: "test@feature@1",
				namespace:    "test",
			},
			wantErr: true,
		},
		{
			name: "fail - non numerical version",
			args: args{
				attributeKey: "test_feature@a",
				namespace:    "test",
			},
			wantErr: true,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := types.NewFeatureKey(tt.args.attributeKey, tt.args.namespace)
			if (err != nil) != tt.wantErr {
				t.Errorf("NewFeatureKey() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if err == nil {
				if !reflect.DeepEqual(got, tt.want) {
					t.Errorf("NewFeatureKey() got = %v, want %v", got, tt.want)
				}
			}
		})
	}
}
