package types_test

import (
	"testing"

	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
)

func TestInstanceKey(t *testing.T) {
	tests := []struct {
		name string
		key  types.InstanceKey
		want string
	}{
		{
			name: "test single entity",
			key: types.InstanceKey{
				FeatureKey: types.FeatureKey{
					FeatureID: "test_id_2",
					Namespace: "test",
					Version:   0,
				},
				Entities: []types.Entity{
					{
						Type: types.QUERY,
						Id:   "query_2",
					},
				},
			},
			want: "query_2",
		},
		{
			name: "test multiple entities",
			key: types.InstanceKey{
				FeatureKey: types.FeatureKey{
					FeatureID: "test_id_1",
					Namespace: "test",
					Version:   0,
				},
				Entities: []types.Entity{
					{
						Type: types.CATEGORY,
						Id:   "category_1",
					},
					{
						Type: types.USER,
						Id:   "user_1",
					},
				},
			},
			want: "category_1#user_1",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {

			if got := tt.key.GetEntityStringKey(); got != tt.want {
				t.Errorf("GetEntityStringKey() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestCacheKey(t *testing.T) {
	tests := []struct {
		name string
		key  types.InstanceKey
		want string
	}{
		{
			name: "test single entity",
			key: types.InstanceKey{
				FeatureKey: types.FeatureKey{
					FeatureID: "test_id_2",
					Namespace: "test",
					Version:   0,
				},
				Entities: []types.Entity{
					{
						Type: types.QUERY,
						Id:   "query_2",
					},
				},
			},
			want: "test_id_2:test:0:query_2",
		},
		{
			name: "test multiple entities",
			key: types.InstanceKey{
				FeatureKey: types.FeatureKey{
					FeatureID: "test_id_1",
					Namespace: "test",
					Version:   0,
				},
				Entities: []types.Entity{
					{
						Type: types.CATEGORY,
						Id:   "category_1",
					},
					{
						Type: types.USER,
						Id:   "user_1",
					},
				},
			},
			want: "test_id_1:test:0:category_1#user_1",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {

			if got := tt.key.GetCacheKey(); got != tt.want {
				t.Errorf("GetCacheKey() = %v, want %v", got, tt.want)
			}
		})
	}
}
