package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
)

// float

type FloatAllValuesValidation struct{ Replacer }

var _ Validater = &FloatAllValuesValidation{}

func (v *FloatAllValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	_, err := validateFloatType(featureValue)
	if err != nil {
		return false, err
	}
	return true, nil
}

// int

type IntAllValuesValidation struct{ Replacer }

var _ Validater = &IntAllValuesValidation{}

func (v *IntAllValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	_, err := validateIntType(featureValue)
	if err != nil {
		return false, err
	}
	return true, nil
}

// string

type StringAllValuesValidation struct{ Replacer }

var _ Validater = &StringAllValuesValidation{}

func (v *StringAllValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	_, err := validateStringType(featureValue)
	if err != nil {
		return false, err
	}
	return true, nil
}
