package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"testing"
)

func TestAllValues(t *testing.T) {
	intValidater := &IntAllValuesValidation{}
	floatValidater := &FloatAllValuesValidation{}
	stringValidater := &StringAllValuesValidation{}

	tests := []testCase{
		{
			name:      "not int",
			validater: intValidater,
			input:     &types.StringFeature{Val: "1"},
			expected:  false,
		},
		{
			name:      "is int",
			validater: intValidater,
			input:     &types.IntFeature{Val: 1},
			expected:  true,
		},
		{
			name:      "not float",
			validater: floatValidater,
			input:     &types.StringFeature{Val: "0.1"},
			expected:  false,
		},
		{
			name:      "is float",
			validater: floatValidater,
			input:     &types.FloatFeature{Val: 1.5},
			expected:  true,
		},
		{
			name:      "not string",
			validater: stringValidater,
			input:     &types.IntFeature{Val: 1},
			expected:  false,
		},
		{
			name:      "is float",
			validater: stringValidater,
			input:     &types.StringFeature{Val: "h"},
			expected:  true,
		},
	}
	runValidateFeatureTests(t, tests)
}
