package validations

import (
	"errors"

	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
)

// float

type FloatAllowedRangeValidation struct {
	Min          *float64
	Max          *float64
	MaxInclusive bool
	MinInclusive bool
	Replacer
}

var _ Validater = &FloatAllowedRangeValidation{}

func (v *FloatAllowedRangeValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	val, err := validateFloatType(featureValue)
	if err != nil {
		return false, err
	}

	return v.isValid(val)
}

func (v *FloatAllowedRangeValidation) isValid(val float64) (bool, error) {
	maxTest := true
	if v.Max != nil {
		if v.MaxInclusive {
			maxTest = val <= *v.Max
		} else {
			maxTest = val < *v.Max
		}
	}
	if !maxTest {
		return false, errors.New("greater than expected max")
	}

	minTest := true
	if v.Min != nil {
		if v.MinInclusive {
			minTest = val >= *v.Min
		} else {
			minTest = val > *v.Min
		}
	}

	if !minTest {
		return false, errors.New("less than expected min")
	}

	return true, nil
}

// int

type IntAllowedRangeValidation struct {
	Min          *int64
	Max          *int64
	MaxInclusive bool
	MinInclusive bool
	Replacer
}

var _ Validater = &IntAllowedRangeValidation{}

func (v *IntAllowedRangeValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	val, err := validateIntType(featureValue)
	if err != nil {
		return false, err
	}

	return v.isValid(val)
}

func (v *IntAllowedRangeValidation) isValid(val int64) (bool, error) {
	maxTest := true
	if v.Max != nil {
		if v.MaxInclusive {
			maxTest = val <= *v.Max
		} else {
			maxTest = val < *v.Max
		}
	}
	if !maxTest {
		return false, errors.New("greater than expected max")
	}

	minTest := true
	if v.Min != nil {
		if v.MinInclusive {
			minTest = val >= *v.Min
		} else {
			minTest = val > *v.Min
		}
	}

	if !minTest {
		return false, errors.New("less than expected min")
	}

	return true, nil
}
