package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"testing"

	"github.com/aws/aws-sdk-go/aws"
)

func TestAllowedRangeInt(t *testing.T) {
	negOne := &types.IntFeature{Val: -1}
	one := &types.IntFeature{Val: 1}

	rangeNonInclusiveValidation := &IntAllowedRangeValidation{
		Max:          aws.Int64(1),
		MaxInclusive: false,
		Min:          aws.Int64(-1),
		MinInclusive: false,
	}

	rangeInclusiveValidation := &IntAllowedRangeValidation{
		Max:          aws.Int64(1),
		MaxInclusive: true,
		Min:          aws.Int64(-1),
		MinInclusive: true,
	}
	minOnlyValidation := &IntAllowedRangeValidation{
		Min:          aws.Int64(0),
		MinInclusive: false,
	}

	maxOnlyValidation := &IntAllowedRangeValidation{
		Max:          aws.Int64(0),
		MaxInclusive: false,
	}

	tests := []testCase{
		{
			name:      "range validation max inclusive success",
			validater: rangeInclusiveValidation,
			input:     one,
			expected:  true,
		},
		{
			name:      "range validation max errors",
			validater: rangeNonInclusiveValidation,
			input:     one,
			expected:  false,
		},
		{
			name:      "range validation min inclusive success",
			validater: rangeInclusiveValidation,
			input:     negOne,
			expected:  true,
		},
		{
			name:      "range validation min errors",
			validater: rangeNonInclusiveValidation,
			input:     negOne,
			expected:  false,
		},
		{
			name:      "range validation min only succeeds",
			validater: minOnlyValidation,
			input:     one,
			expected:  true,
		},
		{
			name:      "range validation max only succeeds",
			validater: maxOnlyValidation,
			input:     negOne,
			expected:  true,
		},
	}

	runValidateFeatureTests(t, tests)
}

func TestAllowedRangeFloat(t *testing.T) {
	negOneFive := &types.FloatFeature{Val: -1.5}
	oneFive := &types.FloatFeature{Val: 1.5}
	twoFive := &types.FloatFeature{Val: 2.0}
	rangeNonInclusiveValidation := &FloatAllowedRangeValidation{
		Max:          aws.Float64(1.5),
		MaxInclusive: false,
		Min:          aws.Float64(-1.5),
		MinInclusive: false,
	}
	rangeInclusiveValidation := &FloatAllowedRangeValidation{
		Max:          aws.Float64(1.5),
		MaxInclusive: true,
		Min:          aws.Float64(-1.5),
		MinInclusive: true,
	}
	minOnlyValidation := &FloatAllowedRangeValidation{
		Min:          aws.Float64(1.5),
		MinInclusive: false,
	}
	maxOnlyValidation := &FloatAllowedRangeValidation{
		Max:          aws.Float64(1.5),
		MaxInclusive: false,
	}

	tests := []testCase{
		{
			name:      "float range validation max inclusive success",
			validater: rangeInclusiveValidation,
			input:     oneFive,
			expected:  true,
		},
		{
			name:      "float range validation max errors",
			validater: rangeNonInclusiveValidation,
			input:     oneFive,
			expected:  false,
		},
		{
			name:      "float range validation min inclusive success",
			validater: rangeInclusiveValidation,
			input:     negOneFive,
			expected:  true,
		},
		{
			name:      "float range validation min errors",
			validater: rangeNonInclusiveValidation,
			input:     negOneFive,
			expected:  false,
		},
		{
			name:      "range validation min only succeeds",
			validater: minOnlyValidation,
			input:     twoFive,
			expected:  true,
		},
		{
			name:      "range validation max only succeeds",
			validater: maxOnlyValidation,
			input:     negOneFive,
			expected:  true,
		},
	}
	runValidateFeatureTests(t, tests)
}
