package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"fmt"

	mapset "github.com/deckarep/golang-set"
)

func allowedValueValidate(featureValue types.FeatureValue, values mapset.Set, val interface{}) (bool, error) {
	if values.Contains(val) {
		return true, nil
	}

	return false, fmt.Errorf("not one of allowed values (%v)", values)
}

// float

type FloatAllowedValuesValidation struct {
	Values []float64
	Replacer
}

var _ Validater = &FloatAllowedValuesValidation{}

func (v *FloatAllowedValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	val, err := validateFloatType(featureValue)
	if err != nil {
		return false, err
	}

	for _, v := range v.Values {
		if isClose(val, v) {
			return true, nil
		}
	}

	return false, fmt.Errorf("not one of allowed values (%v)", v.Values)
}

// int

type IntAllowedValuesValidation struct {
	Values mapset.Set
	Replacer
}

var _ Validater = &IntAllowedValuesValidation{}

func (v *IntAllowedValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	val, err := validateIntType(featureValue)
	if err != nil {
		return false, err
	}

	return allowedValueValidate(featureValue, v.Values, val)
}

// string

type StringAllowedValuesValidation struct {
	Values mapset.Set
	Replacer
}

var _ Validater = &StringAllowedValuesValidation{}

func (v *StringAllowedValuesValidation) Validate(featureValue types.FeatureValue) (bool, error) {
	val, err := validateStringType(featureValue)
	if err != nil {
		return false, err
	}

	return allowedValueValidate(featureValue, v.Values, val)
}
