package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"testing"

	mapset "github.com/deckarep/golang-set"
)

func TestAllowedValuesFloat(t *testing.T) {
	oneFive := &types.FloatFeature{Val: 1.5}
	twoFive := &types.FloatFeature{Val: 2.0}
	setValidation := &FloatAllowedValuesValidation{
		Values: []float64{1.5, -1.5},
	}

	tests := []testCase{
		{
			name:      "float set validation success",
			validater: setValidation,
			input:     oneFive,
			expected:  true,
		},
		{
			name:      "float set validation errors",
			validater: setValidation,
			input:     twoFive,
			expected:  false,
		},
	}
	runValidateFeatureTests(t, tests)
}

func TestAllowedValuesString(t *testing.T) {
	amazon := &types.StringFeature{Val: "amazon"}
	twitch := &types.StringFeature{Val: "twitch"}
	stringSetValidation := &StringAllowedValuesValidation{Values: mapset.NewSetFromSlice([]interface{}{"twitch", "whole_foods"})}

	tests := []testCase{
		{
			name:      "string set validation success",
			validater: stringSetValidation,
			input:     twitch,
			expected:  true,
		},
		{
			name:      "string set validation errors",
			validater: stringSetValidation,
			input:     amazon,
			expected:  false,
		},
	}

	runValidateFeatureTests(t, tests)
}

func TestAllowedValuesInt(t *testing.T) {
	one := &types.IntFeature{Val: 1}
	two := &types.IntFeature{Val: 2}
	setValidation := &IntAllowedValuesValidation{
		Values: mapset.NewSetFromSlice([]interface{}{int64(1), int64(0)}),
	}

	tests := []testCase{
		{
			name:      "set validation success",
			validater: setValidation,
			input:     one,
			expected:  true,
		},
		{
			name:      "set validation errors",
			validater: setValidation,
			input:     two,
			expected:  false,
		},
	}

	runValidateFeatureTests(t, tests)
}
