package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
)

type Replacer interface {
	Replace() types.FeatureValue
}

type Validater interface {
	Validate(types.FeatureValue) (bool, error)
	Replacer
}

func ValidateFeatureAndReplace(validater Validater, featureValue types.FeatureValue) (types.FeatureValue, error) {
	isValid, err := validater.Validate(featureValue)
	if isValid {
		return featureValue, nil
	}
	replacedValue := validater.Replace()
	if replacedValue != nil {
		return replacedValue, nil
	}
	return nil, err
}
