package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"testing"
)

type testCase struct {
	name      string
	validater Validater
	input     types.FeatureValue
	expected  bool
}

func runValidateFeatureTests(t *testing.T, tests []testCase) {
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			actual, _ := tt.validater.Validate(tt.input)
			if actual != tt.expected {
				t.Errorf("%v: expected %v but got %v", tt.name, tt.expected, actual)
			}
		})
	}
}
