package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"errors"
	"math"
)

var (
	absoluteErrorTolerance = 1e-8
	relativeErrorTolerance = 1e-5
)

type FloatReplacementImpl struct {
	Value *float64
}

func (r *FloatReplacementImpl) Replace() types.FeatureValue {
	return floatReplacement(r.Value)
}

func floatReplacement(val *float64) *types.FloatFeature {
	if val == nil {
		return nil
	}
	return &types.FloatFeature{Val: *val}
}

func validateFloatType(featureValue types.FeatureValue) (float64, error) {
	val := featureValue.Value()
	typedVal, ok := val.(float64)
	if !ok {
		return 0, errors.New("cannot cast to integer type")
	}

	return typedVal, nil
}

func isClose(orgVal float64, allowedVal float64) bool {
	return math.Abs(orgVal-allowedVal) <= (absoluteErrorTolerance + relativeErrorTolerance*math.Abs(allowedVal))
}
