package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"errors"
)

type IntReplacementImpl struct {
	Value *int64
}

func (r *IntReplacementImpl) Replace() types.FeatureValue {
	return intReplacement(r.Value)
}

func intReplacement(val *int64) *types.IntFeature {
	if val == nil {
		return nil
	}
	return &types.IntFeature{Val: *val}
}

func validateIntType(featureValue types.FeatureValue) (int64, error) {
	val := featureValue.Value()
	typedVal, ok := val.(int64)
	if !ok {
		return 0, errors.New("cannot cast to integer type")
	}

	return typedVal, nil
}
