package validations

import (
	"code.justin.tv/amzn/TwitchFeatureGo"
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"github.com/aws/aws-sdk-go/aws"
)

func NewReplacer(validation *TwitchFeatureGo.Validation, valueType *TwitchFeatureGo.ValueType) Replacer {
	switch valueType.Type {
	case TwitchFeatureGo.ValueType_DATA_TYPE_INTEGER:
		var replacementVal *int64
		if replacement := validation.Replacement; replacement != nil {
			replacementVal = aws.Int64(replacement.GetIntegerVal())
		}
		return &IntReplacementImpl{Value: replacementVal}
	case TwitchFeatureGo.ValueType_DATA_TYPE_FLOAT:
		var replacementVal *float64
		if replacement := validation.Replacement; replacement != nil {
			replacementVal = aws.Float64(replacement.GetFloatVal())
		}
		return &FloatReplacementImpl{Value: replacementVal}
	case TwitchFeatureGo.ValueType_DATA_TYPE_STRING:
		var replacementVal *string
		if replacement := validation.Replacement; replacement != nil {
			replacementVal = aws.String(replacement.GetStringVal())
		}
		return &StringReplacementImpl{Value: replacementVal}
	}

	return &NoOpReplacerImpl{}
}

type NoOpReplacerImpl struct{}

var _ Replacer = &NoOpReplacerImpl{}

func (*NoOpReplacerImpl) Replace() types.FeatureValue {
	return nil
}
