package validations

import (
	"code.justin.tv/amzn/TwitchFeatureStoreClient/types"
	"errors"
)

type StringReplacementImpl struct {
	Value *string
}

var _ Replacer = &StringReplacementImpl{}

func (r *StringReplacementImpl) Replace() types.FeatureValue {
	if r.Value == nil {
		return nil
	}
	return &types.StringFeature{Val: *r.Value}
}

func validateStringType(featureValue types.FeatureValue) (string, error) {
	val := featureValue.Value()
	typedVal, ok := val.(string)
	if !ok {
		return "", errors.New("cannot cast to integer type")
	}

	return typedVal, nil
}
