package requestlog_test

import (
	"context"
	"encoding/json"
	"testing"

	"code.justin.tv/amzn/TwitchGoRequestLog/requestlog"
	"github.com/stretchr/testify/require"
)

func Test_MarshalJSON(t *testing.T) {
	ctx := requestlog.EnsureTrace(context.Background())

	requestlog.SetTraceInt(ctx, "someint", 5)
	requestlog.SetTraceFloat(ctx, "somefloat", 0.5)
	requestlog.SetTraceString(ctx, "somestring", "value")

	trace := requestlog.GetTrace(ctx)

	b, err := json.Marshal(trace)
	require.NoError(t, err)

	require.Contains(t, string(b), `"ints":{"someint":5}`)
	require.Contains(t, string(b), `"floats":{"somefloat":0.5}`)
	require.Contains(t, string(b), `"strings":{"somestring":"value"}`)
}
