package sessionsclient

import (
	"context"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

const MaxBulkDeleteUserBatchSize = 250

type BulkDeleteSessionsRequest struct {
	UserIDs []string `json:"user_ids"`
}

func (c *client) BulkDeleteSessions(ctx context.Context, deleteReq *BulkDeleteSessionsRequest) error {
	_, err := c.client.Do(ctx, twitchclient.JSONRequest{
		Method: http.MethodPost,
		Path:   "/bulk_delete_sessions",
		Body:   deleteReq,
	}, nil)
	if err != nil {
		if e, ok := err.(*twitchclient.Error); ok {
			return parseErrorResponse(e)
		}
		return err
	}
	return nil
}
