package sessionsclient

import (
	"context"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

// DeleteSessionRequest is the DeleteSession request
type DeleteSessionRequest struct {
	ClientID string `json:"client_id"`
	Token    string `json:"token"`
}

func (c *client) DeleteSession(ctx context.Context, deleteReq *DeleteSessionRequest) error {
	if _, err := parseToken(deleteReq.Token); err != nil {
		return ErrInvalidToken
	}

	_, err := c.client.Do(ctx, twitchclient.JSONRequest{
		Method: http.MethodDelete,
		Path:   "/sessions",
		Body:   deleteReq,
	}, nil)
	if err != nil {
		if e, ok := err.(*twitchclient.Error); ok {
			return parseErrorResponse(e)
		}
		return err
	}

	return nil
}
