package sessionsclient

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
)

// InvalidateSessionRequest is the Invalidate request
type InvalidateSessionRequest struct {
	ClientID string `json:"client_id"`
	Token    string `json:"token"`
}

func (c *client) Invalidate(ctx context.Context, invalidateReq *InvalidateSessionRequest) error {
	if _, err := parseToken(invalidateReq.Token); err != nil {
		return ErrInvalidToken
	}

	err := c.client.Post(ctx, "/sessions/invalidate", invalidateReq, nil)
	if err != nil {
		if e, ok := err.(*twitchclient.Error); ok {
			return parseErrorResponse(e)
		}
		return err
	}

	return nil
}
