package sessionsclient

import (
	"context"
	"fmt"

	"code.justin.tv/foundation/twitchclient"
)

type InvalidateSessionsRequest struct {
	ClientID    string `json:"client_id"`
	KeepSession string `json:"keep_session,omitempty"`
}

func (c *client) InvalidateSessions(ctx context.Context, userID string, params *InvalidateSessionsRequest) error {
	if userID == "" {
		return ErrUserIDRequired
	}

	if params == nil || params.ClientID == "" {
		return ErrInvalidRequestParams
	}

	err := c.client.Post(ctx, fmt.Sprintf("/sessions/%s/invalidate", userID), params, nil)
	if err != nil {
		if e, ok := err.(*twitchclient.Error); ok {
			return parseErrorResponse(e)
		}
		return err
	}

	return nil
}
