package sessionsclient

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
)

// ListSessionsResponse is returned from ListSessions
type ListSessionsResponse struct {
	Sessions []*Session `json:"sessions"`
}

// ListSessionsRequest is the request
type ListSessionsRequest struct {
}

func (c *client) ListSessions(ctx context.Context, userid string) ([]*Session, error) {
	if len(userid) == 0 {
		return nil, ErrInvalidRequestParams
	}

	var listSessionsResponse ListSessionsResponse
	err := c.client.Post(ctx, "/sessions/"+userid, ListSessionsRequest{}, &listSessionsResponse)
	if err != nil {
		if e, ok := err.(*twitchclient.Error); ok {
			return nil, parseErrorResponse(e)
		}
		return nil, err
	}

	return listSessionsResponse.Sessions, nil
}
