package sessionsclient

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestParseTokenSuccess(t *testing.T) {
	token := "useruser::tokentoken"
	_, err := parseToken(token)
	assert.Nil(t, err, "Should parse decoded token successfully")
}

func TestParseTokenSuccessEncoded(t *testing.T) {
	token := "useruser%3A%3Atokentoken"
	_, err := parseToken(token)
	assert.Nil(t, err, "Should parse encoded token successfully also")
}

func TestParseTokenFailureMalformed(t *testing.T) {
	token := "muahahaha i am an evil malformed token"
	_, err := parseToken(token)
	assert.Equal(t, ErrInvalidToken, err, "Should fail for malformed token")
}
