// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchLedgerTwirp/twirp.proto

/*
Package TwitchLedgerTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchLedgerTwirp/twirp.proto
*/
package TwitchLedgerTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ======================
// TwitchLedger Interface
// ======================

type TwitchLedger interface {
	GetTag(context.Context, *GetTagReq) (*Tag, error)

	ListTags(context.Context, *ListTagsReq) (*Tags, error)

	GetCategory(context.Context, *GetCategoryReq) (*Category, error)

	ListCategories(context.Context, *ListCategoriesReq) (*Categories, error)

	GetExpectation(context.Context, *GetExpectationReq) (*Expectation, error)

	ListExpectations(context.Context, *ListExpectationsReq) (*Expectations, error)

	GetExpectationStatus(context.Context, *GetExpectationStatusReq) (*ExpectationStatus, error)

	ListExpectationStatuses(context.Context, *ListExpectationStatusesReq) (*ExpectationStatuses, error)

	ListExpectationStatusChanges(context.Context, *ListExpectationStatusChangesReq) (*ExpectationStatusChanges, error)

	UpdateExpectationStatus(context.Context, *UpdateExpectationStatusReq) (*ExpectationStatus, error)

	UpdateScrapedExpectationStatus(context.Context, *UpdateScrapedExpectationStatusReq) (*ExpectationStatus, error)

	UpdateUserExpectationStatus(context.Context, *UpdateUserExpectationStatusReq) (*ExpectationStatus, error)
}

// ============================
// TwitchLedger Protobuf Client
// ============================

type twitchLedgerProtobufClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewTwitchLedgerProtobufClient creates a Protobuf client that implements the TwitchLedger interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchLedgerProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchLedger {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchLedgerPathPrefix
	urls := [12]string{
		prefix + "GetTag",
		prefix + "ListTags",
		prefix + "GetCategory",
		prefix + "ListCategories",
		prefix + "GetExpectation",
		prefix + "ListExpectations",
		prefix + "GetExpectationStatus",
		prefix + "ListExpectationStatuses",
		prefix + "ListExpectationStatusChanges",
		prefix + "UpdateExpectationStatus",
		prefix + "UpdateScrapedExpectationStatus",
		prefix + "UpdateUserExpectationStatus",
	}

	return &twitchLedgerProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchLedgerProtobufClient) GetTag(ctx context.Context, in *GetTagReq) (*Tag, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetTag")
	out := new(Tag)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) ListTags(ctx context.Context, in *ListTagsReq) (*Tags, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListTags")
	out := new(Tags)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) GetCategory(ctx context.Context, in *GetCategoryReq) (*Category, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	out := new(Category)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) ListCategories(ctx context.Context, in *ListCategoriesReq) (*Categories, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListCategories")
	out := new(Categories)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) GetExpectation(ctx context.Context, in *GetExpectationReq) (*Expectation, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectation")
	out := new(Expectation)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) ListExpectations(ctx context.Context, in *ListExpectationsReq) (*Expectations, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectations")
	out := new(Expectations)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) GetExpectationStatus(ctx context.Context, in *GetExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) ListExpectationStatuses(ctx context.Context, in *ListExpectationStatusesReq) (*ExpectationStatuses, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatuses")
	out := new(ExpectationStatuses)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) ListExpectationStatusChanges(ctx context.Context, in *ListExpectationStatusChangesReq) (*ExpectationStatusChanges, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatusChanges")
	out := new(ExpectationStatusChanges)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) UpdateExpectationStatus(ctx context.Context, in *UpdateExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) UpdateScrapedExpectationStatus(ctx context.Context, in *UpdateScrapedExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateScrapedExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerProtobufClient) UpdateUserExpectationStatus(ctx context.Context, in *UpdateUserExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ========================
// TwitchLedger JSON Client
// ========================

type twitchLedgerJSONClient struct {
	client HTTPClient
	urls   [12]string
	opts   twirp.ClientOptions
}

// NewTwitchLedgerJSONClient creates a JSON client that implements the TwitchLedger interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchLedgerJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchLedger {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchLedgerPathPrefix
	urls := [12]string{
		prefix + "GetTag",
		prefix + "ListTags",
		prefix + "GetCategory",
		prefix + "ListCategories",
		prefix + "GetExpectation",
		prefix + "ListExpectations",
		prefix + "GetExpectationStatus",
		prefix + "ListExpectationStatuses",
		prefix + "ListExpectationStatusChanges",
		prefix + "UpdateExpectationStatus",
		prefix + "UpdateScrapedExpectationStatus",
		prefix + "UpdateUserExpectationStatus",
	}

	return &twitchLedgerJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchLedgerJSONClient) GetTag(ctx context.Context, in *GetTagReq) (*Tag, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetTag")
	out := new(Tag)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) ListTags(ctx context.Context, in *ListTagsReq) (*Tags, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListTags")
	out := new(Tags)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) GetCategory(ctx context.Context, in *GetCategoryReq) (*Category, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	out := new(Category)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) ListCategories(ctx context.Context, in *ListCategoriesReq) (*Categories, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListCategories")
	out := new(Categories)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) GetExpectation(ctx context.Context, in *GetExpectationReq) (*Expectation, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectation")
	out := new(Expectation)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) ListExpectations(ctx context.Context, in *ListExpectationsReq) (*Expectations, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectations")
	out := new(Expectations)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) GetExpectationStatus(ctx context.Context, in *GetExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) ListExpectationStatuses(ctx context.Context, in *ListExpectationStatusesReq) (*ExpectationStatuses, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatuses")
	out := new(ExpectationStatuses)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) ListExpectationStatusChanges(ctx context.Context, in *ListExpectationStatusChangesReq) (*ExpectationStatusChanges, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatusChanges")
	out := new(ExpectationStatusChanges)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) UpdateExpectationStatus(ctx context.Context, in *UpdateExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) UpdateScrapedExpectationStatus(ctx context.Context, in *UpdateScrapedExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateScrapedExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchLedgerJSONClient) UpdateUserExpectationStatus(ctx context.Context, in *UpdateUserExpectationStatusReq) (*ExpectationStatus, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserExpectationStatus")
	out := new(ExpectationStatus)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===========================
// TwitchLedger Server Handler
// ===========================

type twitchLedgerServer struct {
	TwitchLedger
	hooks *twirp.ServerHooks
}

func NewTwitchLedgerServer(svc TwitchLedger, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchLedgerServer{
		TwitchLedger: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchLedgerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchLedgerPathPrefix is used for all URL paths on a twirp TwitchLedger server.
// Requests are always: POST TwitchLedgerPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchLedgerPathPrefix = "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/"

func (s *twitchLedgerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.twitchledger")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchLedger")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/GetTag":
		s.serveGetTag(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/ListTags":
		s.serveListTags(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/GetCategory":
		s.serveGetCategory(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/ListCategories":
		s.serveListCategories(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/GetExpectation":
		s.serveGetExpectation(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/ListExpectations":
		s.serveListExpectations(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/GetExpectationStatus":
		s.serveGetExpectationStatus(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/ListExpectationStatuses":
		s.serveListExpectationStatuses(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/ListExpectationStatusChanges":
		s.serveListExpectationStatusChanges(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/UpdateExpectationStatus":
		s.serveUpdateExpectationStatus(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/UpdateScrapedExpectationStatus":
		s.serveUpdateScrapedExpectationStatus(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.twitchledger.TwitchLedger/UpdateUserExpectationStatus":
		s.serveUpdateUserExpectationStatus(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchLedgerServer) serveGetTag(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTagJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTagProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveGetTagJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTagReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Tag
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetTag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Tag and nil error while calling GetTag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetTagProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTag")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTagReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Tag
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetTag(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Tag and nil error while calling GetTag. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListTags(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListTagsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListTagsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveListTagsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTags")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListTagsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Tags
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListTags(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Tags and nil error while calling ListTags. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListTagsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTags")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListTagsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Tags
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListTags(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Tags and nil error while calling ListTags. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveGetCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Category
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Category and nil error while calling GetCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoryReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Category
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Category and nil error while calling GetCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveListCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCategoriesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Categories
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Categories and nil error while calling ListCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListCategoriesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Categories
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Categories and nil error while calling ListCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetExpectation(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExpectationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExpectationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveGetExpectationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetExpectationReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Expectation
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetExpectation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Expectation and nil error while calling GetExpectation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetExpectationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectation")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetExpectationReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Expectation
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetExpectation(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Expectation and nil error while calling GetExpectation. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListExpectationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListExpectationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveListExpectationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListExpectationsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Expectations
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Expectations and nil error while calling ListExpectations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListExpectationsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Expectations
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Expectations and nil error while calling ListExpectations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetExpectationStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetExpectationStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExpectationStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveGetExpectationStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetExpectationStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling GetExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveGetExpectationStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetExpectationStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.GetExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling GetExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectationStatuses(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListExpectationStatusesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListExpectationStatusesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveListExpectationStatusesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListExpectationStatusesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatuses
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectationStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatuses and nil error while calling ListExpectationStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectationStatusesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatuses")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListExpectationStatusesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatuses
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectationStatuses(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatuses and nil error while calling ListExpectationStatuses. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectationStatusChanges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListExpectationStatusChangesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListExpectationStatusChangesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveListExpectationStatusChangesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatusChanges")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListExpectationStatusChangesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatusChanges
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectationStatusChanges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatusChanges and nil error while calling ListExpectationStatusChanges. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveListExpectationStatusChangesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListExpectationStatusChanges")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListExpectationStatusChangesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatusChanges
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.ListExpectationStatusChanges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatusChanges and nil error while calling ListExpectationStatusChanges. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateExpectationStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateExpectationStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateExpectationStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveUpdateExpectationStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateExpectationStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateExpectationStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateExpectationStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateScrapedExpectationStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateScrapedExpectationStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateScrapedExpectationStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveUpdateScrapedExpectationStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateScrapedExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateScrapedExpectationStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateScrapedExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateScrapedExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateScrapedExpectationStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateScrapedExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateScrapedExpectationStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateScrapedExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateScrapedExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateUserExpectationStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateUserExpectationStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateUserExpectationStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchLedgerServer) serveUpdateUserExpectationStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateUserExpectationStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateUserExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateUserExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) serveUpdateUserExpectationStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateUserExpectationStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateUserExpectationStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ExpectationStatus
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchLedger.UpdateUserExpectationStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ExpectationStatus and nil error while calling UpdateUserExpectationStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchLedgerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchLedgerServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchLedgerServer) PathPrefix() string {
	return TwitchLedgerPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1420 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xcd, 0x6e, 0x1b, 0xd5,
	0x17, 0xef, 0x38, 0x8e, 0xe3, 0x1c, 0x3b, 0xae, 0x73, 0x92, 0x7f, 0x63, 0x4d, 0xfe, 0xa2, 0x61,
	0x42, 0x21, 0x2d, 0xaa, 0x4d, 0x53, 0xa9, 0x2a, 0x52, 0x11, 0x72, 0x6d, 0x37, 0xb2, 0xd4, 0xa6,
	0xd5, 0x64, 0x52, 0x51, 0x58, 0x8c, 0xc6, 0x33, 0xb7, 0xee, 0x45, 0xb6, 0xc7, 0x9d, 0x7b, 0xc7,
	0xad, 0xbb, 0x81, 0x0d, 0x2b, 0x90, 0x40, 0x08, 0xb1, 0x60, 0x85, 0xc4, 0x03, 0xf0, 0x06, 0xbc,
	0x00, 0x7b, 0xd6, 0xb0, 0xe2, 0x35, 0xd0, 0xcc, 0xdc, 0x19, 0x8f, 0xbf, 0xa2, 0xb1, 0x0b, 0xe5,
	0x63, 0x63, 0xf9, 0x9e, 0x73, 0xee, 0x3d, 0x5f, 0xbf, 0x73, 0x7c, 0x8e, 0xe1, 0x9a, 0x69, 0x5b,
	0xa4, 0xfc, 0xb1, 0xcb, 0x38, 0xed, 0x95, 0xf9, 0xa0, 0x62, 0x74, 0x5f, 0xf4, 0x2a, 0xda, 0x33,
	0xca, 0xcd, 0x27, 0x77, 0x89, 0xd5, 0x26, 0x8e, 0xf6, 0x8c, 0x3a, 0xfd, 0x0a, 0xf7, 0x3e, 0xcb,
	0x7d, 0xc7, 0xe6, 0x36, 0xee, 0x73, 0x9f, 0x5d, 0x6e, 0xb9, 0xb4, 0x63, 0x11, 0xa7, 0xef, 0xd8,
	0x96, 0x6b, 0x72, 0x56, 0x0e, 0xc8, 0x1d, 0xff, 0x96, 0x7c, 0xb1, 0x6d, 0xdb, 0xed, 0x0e, 0xa9,
	0xf8, 0x57, 0x5a, 0xee, 0xe3, 0x0a, 0xa7, 0x5d, 0xc2, 0xb8, 0xd1, 0x15, 0xaf, 0x28, 0x9f, 0x4a,
	0xb0, 0xa2, 0x19, 0x6d, 0x2c, 0x40, 0x8a, 0x5a, 0x25, 0x69, 0x4f, 0x3a, 0x58, 0x55, 0x53, 0xd4,
	0x42, 0x84, 0x74, 0xcf, 0xe8, 0x92, 0x52, 0x6a, 0x4f, 0x3a, 0x58, 0x57, 0xfd, 0xef, 0xb8, 0x07,
	0x39, 0x8b, 0x30, 0xd3, 0xa1, 0x7d, 0x4e, 0xed, 0x5e, 0x69, 0xc5, 0x67, 0xc5, 0x49, 0x78, 0x01,
	0x32, 0x86, 0xcb, 0x9f, 0xd8, 0x4e, 0x29, 0xed, 0x33, 0xc5, 0x09, 0x77, 0x61, 0x9d, 0x32, 0xdd,
	0x30, 0x39, 0x1d, 0x90, 0xd2, 0xea, 0x9e, 0x74, 0x90, 0x55, 0xb3, 0x94, 0x55, 0xfd, 0xb3, 0x52,
	0x87, 0xb4, 0x66, 0xb4, 0x19, 0xde, 0x82, 0x34, 0x37, 0xda, 0xac, 0x24, 0xed, 0xad, 0x1c, 0xe4,
	0x0e, 0x0f, 0xca, 0x09, 0xfc, 0x2b, 0x6b, 0x46, 0x5b, 0xf5, 0x6f, 0x29, 0xbb, 0xb0, 0x7e, 0x44,
	0xb8, 0x77, 0x26, 0x4f, 0x27, 0xbd, 0x51, 0x36, 0x20, 0x77, 0x97, 0x32, 0x8f, 0xcb, 0x54, 0xf2,
	0x54, 0xf9, 0x4c, 0x82, 0x6c, 0xcd, 0xe0, 0xa4, 0x6d, 0x3b, 0xc3, 0xbf, 0xd3, 0xf3, 0x8f, 0x00,
	0x84, 0x19, 0x94, 0x30, 0xbc, 0x07, 0x60, 0x46, 0x27, 0x11, 0x85, 0xab, 0x89, 0xa2, 0x10, 0xfa,
	0xa2, 0xc6, 0x1e, 0x50, 0xf6, 0xa0, 0x70, 0x44, 0x78, 0xc4, 0x9a, 0x11, 0x95, 0x2d, 0xd8, 0xf4,
	0xa2, 0x32, 0x32, 0xc1, 0x8b, 0xcd, 0x97, 0x69, 0xc8, 0x35, 0x9e, 0xf7, 0x89, 0xc9, 0x0d, 0xdf,
	0xb1, 0xc9, 0xf0, 0xdc, 0x80, 0x1d, 0xf2, 0x9c, 0x13, 0xa7, 0x67, 0x74, 0x74, 0x32, 0x92, 0xd3,
	0xa9, 0x25, 0x22, 0xf6, 0xbf, 0x90, 0x1d, 0x7b, 0xa5, 0x69, 0x61, 0x13, 0xb2, 0xc2, 0xb8, 0xa1,
	0x1f, 0xbf, 0x85, 0x7d, 0x8b, 0xae, 0xe3, 0x03, 0xc8, 0x91, 0x1e, 0xa7, 0x7c, 0xa8, 0xf3, 0x61,
	0x9f, 0xf8, 0x01, 0x2f, 0x1c, 0x56, 0x12, 0xbd, 0xd6, 0xf0, 0xef, 0x69, 0xc3, 0x3e, 0x51, 0x81,
	0x44, 0xdf, 0xf1, 0x12, 0x14, 0xc8, 0x80, 0x5a, 0xa4, 0x67, 0x12, 0xbd, 0x65, 0x30, 0x62, 0x89,
	0x54, 0x6d, 0x84, 0xd4, 0xdb, 0x1e, 0x11, 0xdf, 0x86, 0x4d, 0xcb, 0x36, 0xdd, 0x2e, 0xe9, 0x09,
	0xa7, 0x5d, 0xa7, 0x53, 0xca, 0xf8, 0x5e, 0x17, 0xc7, 0x18, 0xa7, 0x4e, 0x07, 0x4b, 0xb0, 0xc6,
	0xdc, 0x6e, 0xd7, 0x70, 0x86, 0xa5, 0x35, 0x5f, 0x24, 0x3c, 0x4e, 0xa2, 0x29, 0x7b, 0x16, 0x9a,
	0xd6, 0xe7, 0xa3, 0x09, 0xc6, 0xd1, 0x14, 0xd5, 0x4f, 0x6e, 0x99, 0xfa, 0xf1, 0xcc, 0xe5, 0xb6,
	0xdd, 0xe1, 0xb4, 0x5f, 0xca, 0x07, 0xe6, 0x8a, 0xa3, 0x62, 0x41, 0x3e, 0x96, 0x4a, 0x86, 0x1a,
	0xe4, 0x63, 0x89, 0x0f, 0x91, 0xfa, 0x4e, 0xb2, 0xf8, 0x8f, 0x2e, 0xaa, 0x63, 0xaf, 0x28, 0xfb,
	0xb0, 0x79, 0x44, 0x78, 0x9c, 0x3f, 0x03, 0xb1, 0x6d, 0xd8, 0xf2, 0x10, 0x1b, 0x37, 0xc7, 0x13,
	0x9b, 0x00, 0x84, 0xf4, 0xd2, 0x80, 0x50, 0x7e, 0x4e, 0xc3, 0x66, 0x4c, 0xcb, 0x09, 0x37, 0xb8,
	0xcb, 0x50, 0x85, 0x5c, 0xcc, 0x66, 0x5f, 0xcf, 0x32, 0x8e, 0xc7, 0x1f, 0x99, 0xb4, 0x3d, 0xf5,
	0xf2, 0x60, 0xde, 0x85, 0x75, 0xf1, 0x22, 0xb5, 0x44, 0xab, 0xca, 0x06, 0x84, 0xa6, 0x85, 0xfb,
	0xb0, 0xc1, 0x4c, 0xc7, 0xe8, 0x13, 0x4b, 0x1f, 0x18, 0x1d, 0x97, 0x88, 0x76, 0x95, 0x17, 0xc4,
	0x87, 0x1e, 0x0d, 0x0f, 0xa0, 0xe8, 0x32, 0xe2, 0xe8, 0xb4, 0xd7, 0x77, 0xb9, 0x90, 0x5b, 0xf5,
	0xe5, 0x0a, 0x1e, 0xbd, 0xe9, 0x91, 0x03, 0xc9, 0x7d, 0xd8, 0xb0, 0x88, 0x43, 0x07, 0xd1, 0x73,
	0x41, 0x35, 0xe4, 0x05, 0x31, 0x10, 0xaa, 0xc0, 0x96, 0x69, 0x77, 0xfb, 0x1d, 0x6a, 0x78, 0xf5,
	0x15, 0x96, 0x94, 0xa8, 0x0a, 0x1c, 0xb1, 0x1a, 0x82, 0x83, 0x57, 0x01, 0x07, 0xd4, 0xee, 0x04,
	0x35, 0x16, 0xc9, 0x07, 0x75, 0xb2, 0x19, 0x71, 0x22, 0xf1, 0x37, 0xe1, 0x3c, 0xf3, 0x13, 0xa4,
	0xf7, 0x0d, 0xc6, 0x75, 0xcb, 0x25, 0x7e, 0xd9, 0x64, 0xd5, 0x8d, 0x80, 0xfc, 0xc0, 0x60, 0xbc,
	0xee, 0x12, 0xaf, 0x7c, 0x85, 0x1c, 0xed, 0xf9, 0x5a, 0x09, 0x0f, 0xab, 0xa8, 0x18, 0x30, 0x9a,
	0x11, 0x1d, 0x2f, 0x83, 0xa0, 0xe9, 0xa6, 0xdd, 0xed, 0x52, 0xce, 0x89, 0x55, 0xca, 0xf9, 0xb2,
	0x42, 0x59, 0x2d, 0x24, 0xe3, 0x45, 0xc8, 0x09, 0x51, 0xcb, 0xee, 0x11, 0xbf, 0x7c, 0xb2, 0x2a,
	0x04, 0xa4, 0xba, 0xdd, 0x23, 0xde, 0x8f, 0xec, 0xd6, 0x14, 0x9a, 0x08, 0x43, 0x0a, 0xdb, 0xf1,
	0x16, 0xca, 0x04, 0x5d, 0x54, 0xd4, 0x8d, 0x45, 0x81, 0x15, 0xbc, 0xab, 0x6e, 0x91, 0x69, 0x55,
	0xca, 0x2f, 0x29, 0xd8, 0x99, 0x12, 0xad, 0x3d, 0x31, 0x7a, 0xed, 0xa0, 0xfb, 0x8d, 0x77, 0xf2,
	0xa0, 0xe2, 0x36, 0xc8, 0x58, 0x07, 0x7f, 0xc5, 0x48, 0x7d, 0x17, 0xc0, 0xf4, 0xed, 0xb3, 0x74,
	0x83, 0xfb, 0x30, 0xcd, 0x1d, 0xca, 0xe5, 0x60, 0x9e, 0x29, 0x87, 0xf3, 0x4c, 0x59, 0x0b, 0xe7,
	0x19, 0x75, 0x5d, 0x48, 0x57, 0x39, 0xbe, 0x01, 0x85, 0xf0, 0x6a, 0x6b, 0xa8, 0xbb, 0xd4, 0x12,
	0xe8, 0xcd, 0x0b, 0xea, 0xed, 0xe1, 0x29, 0xb5, 0xfc, 0x26, 0x6b, 0xfa, 0x85, 0x9c, 0x11, 0x4d,
	0xd6, 0x0c, 0x9b, 0x6f, 0x8b, 0x3c, 0xb6, 0x9d, 0x10, 0xa1, 0xe2, 0x84, 0xdb, 0xb0, 0x6a, 0x3c,
	0xe6, 0xc4, 0x11, 0x40, 0x0c, 0x0e, 0xca, 0xb7, 0x12, 0x94, 0xe6, 0x04, 0x96, 0xe1, 0x0b, 0x90,
	0xa7, 0x13, 0xac, 0x07, 0x56, 0x84, 0x69, 0xbe, 0xb5, 0x5c, 0x9a, 0x03, 0x15, 0x6a, 0x89, 0xcc,
	0xd1, 0xad, 0xfc, 0x96, 0x02, 0xf9, 0xb4, 0x6f, 0x19, 0x9c, 0x4c, 0x43, 0xe4, 0xaf, 0xe8, 0x99,
	0xe3, 0xd9, 0x4c, 0x4d, 0x64, 0x73, 0x1a, 0x63, 0x2b, 0xb3, 0x30, 0xf6, 0x27, 0xb7, 0xa7, 0x39,
	0x9d, 0x27, 0xb3, 0x60, 0xe7, 0x59, 0x9b, 0xd3, 0x79, 0x94, 0x5f, 0x25, 0x78, 0x2d, 0x88, 0xf1,
	0x29, 0x23, 0xce, 0xbf, 0x28, 0xce, 0xb3, 0x42, 0x98, 0x9e, 0x15, 0x42, 0xe5, 0xa7, 0x14, 0xbc,
	0x1e, 0xb8, 0x78, 0x12, 0xe4, 0xe0, 0xbf, 0x86, 0xa6, 0x39, 0x18, 0x59, 0x5d, 0x10, 0x23, 0x99,
	0x79, 0x18, 0xf9, 0x51, 0x82, 0x9d, 0xf1, 0xc9, 0x66, 0x14, 0xb6, 0x7f, 0x64, 0xe7, 0x55, 0x3e,
	0x97, 0x40, 0x9e, 0x18, 0xb3, 0xc2, 0xdf, 0x91, 0x57, 0x9f, 0x6b, 0xe5, 0x2b, 0x09, 0x2e, 0xce,
	0xb4, 0x46, 0x34, 0xba, 0x57, 0x6f, 0xd2, 0x95, 0x7b, 0x00, 0xa3, 0x6b, 0xb8, 0x0d, 0xc5, 0xd3,
	0xe3, 0x7a, 0xe3, 0x4e, 0xf3, 0xb8, 0x51, 0xd7, 0x1b, 0xc7, 0x5a, 0x53, 0x7b, 0x54, 0x3c, 0x87,
	0x39, 0x58, 0x3b, 0x69, 0xa8, 0x0f, 0x9b, 0xb5, 0x46, 0x51, 0xc2, 0x2c, 0xa4, 0xb5, 0x46, 0xf5,
	0x5e, 0x31, 0x85, 0x08, 0x85, 0xe6, 0xf1, 0xc3, 0xea, 0xdd, 0x66, 0x24, 0xba, 0x72, 0x65, 0x00,
	0xa0, 0x12, 0xd3, 0x76, 0xac, 0xe9, 0xe7, 0xd4, 0x46, 0xed, 0xbe, 0x5a, 0x2f, 0x9e, 0xc3, 0x35,
	0x58, 0xd1, 0xaa, 0x47, 0x45, 0x09, 0xf3, 0x90, 0xad, 0x55, 0xb5, 0xc6, 0xd1, 0x7d, 0xf5, 0x51,
	0x31, 0x85, 0xe7, 0x21, 0xd7, 0xf8, 0xe0, 0x41, 0xa3, 0xa6, 0x55, 0xb5, 0xe6, 0xfd, 0xe3, 0xe2,
	0x0a, 0x5e, 0x00, 0x8c, 0x11, 0xf4, 0x13, 0xad, 0xaa, 0x9d, 0x9e, 0x14, 0xd3, 0x71, 0xbd, 0xe2,
	0xcd, 0xd5, 0xc3, 0xdf, 0xf3, 0x90, 0x8f, 0xff, 0xc7, 0x80, 0x2d, 0xc8, 0x04, 0x3b, 0x34, 0x96,
	0x13, 0xc5, 0x2e, 0x5a, 0xb8, 0xe5, 0xc4, 0xdb, 0x06, 0xb6, 0x21, 0x1b, 0xae, 0xe2, 0x98, 0x6c,
	0x74, 0x8e, 0x6d, 0xee, 0xf2, 0xe5, 0xa4, 0x7a, 0x18, 0x3e, 0x85, 0x5c, 0x6c, 0xff, 0xc5, 0xeb,
	0x49, 0x3d, 0x8a, 0x6d, 0xcc, 0xf2, 0x62, 0x2b, 0x2a, 0x0e, 0xa1, 0x30, 0xbe, 0x50, 0xe3, 0x8d,
	0xc4, 0x1e, 0x8e, 0x6d, 0xe1, 0x72, 0x65, 0x11, 0xc5, 0xd4, 0x9f, 0x34, 0x0a, 0xe3, 0x4d, 0x26,
	0xa1, 0xea, 0xa9, 0x9d, 0x4b, 0x5e, 0x78, 0x9f, 0xc1, 0x4f, 0xa0, 0x38, 0xb9, 0x95, 0xe1, 0xcd,
	0xc4, 0x8e, 0x4f, 0x2c, 0x73, 0xf2, 0xb5, 0x45, 0xf5, 0x33, 0xfc, 0x42, 0x82, 0xed, 0x59, 0x2d,
	0x16, 0x6f, 0x2d, 0x11, 0x83, 0xa8, 0x3b, 0xcb, 0x4b, 0x0e, 0xe0, 0xf8, 0x8d, 0x04, 0x3b, 0x73,
	0xfa, 0x27, 0xbe, 0xbf, 0x4c, 0x5c, 0x62, 0xdd, 0x57, 0xbe, 0xb9, 0x9c, 0x51, 0x84, 0xe1, 0x0f,
	0x12, 0xfc, 0xff, 0xac, 0x46, 0x8a, 0xf5, 0xe5, 0x6d, 0x1b, 0xf5, 0x62, 0xf9, 0xbd, 0x97, 0x99,
	0x67, 0x19, 0x7e, 0x2d, 0xc1, 0xce, 0x9c, 0xb1, 0x35, 0x61, 0xf0, 0xe6, 0x0f, 0xbd, 0x4b, 0x67,
	0xf4, 0xfb, 0x68, 0xce, 0x9b, 0x37, 0x04, 0xe1, 0x9d, 0x05, 0x6c, 0x3b, 0x63, 0x92, 0x5a, 0xda,
	0xc4, 0xef, 0x24, 0xd8, 0x3d, 0x63, 0x14, 0xc5, 0xda, 0x02, 0xf6, 0xcd, 0x1b, 0x66, 0x97, 0x35,
	0xee, 0xf6, 0x5b, 0x1f, 0x5e, 0x4a, 0xf4, 0x07, 0x77, 0x2b, 0xe3, 0x2f, 0x76, 0xd7, 0xff, 0x08,
	0x00, 0x00, 0xff, 0xff, 0xa1, 0xed, 0xb5, 0xe1, 0x10, 0x17, 0x00, 0x00,
}
