package logmiddleware

import (
	"context"

	logging "code.justin.tv/amzn/TwitchLogging"
	"github.com/twitchtv/twirp"
)

const (
	twirpStatusKey = "TwirpStatusCode"
)

// Server middleware for logging errors that occurr when handling requests.
type Server struct {
	Logger logging.Logger

	// These error codes will not be logged.
	SuppressedErrorCodes []twirp.ErrorCode
}

// ServerHooks returns Twirp hooks for logging errors.
func (s *Server) ServerHooks() *twirp.ServerHooks {
	return &twirp.ServerHooks{
		Error: func(ctx context.Context, err twirp.Error) context.Context {
			s.log(err)
			return ctx
		},
	}
}

func (s *Server) log(err twirp.Error) {
	if s.Logger == nil || err == nil {
		return
	}

	errCode := err.Code()
	for _, suppressed := range s.SuppressedErrorCodes {
		if errCode == suppressed {
			return
		}
	}

	s.Logger.Log("Error while handling request: " + err.Error(),
		twirpStatusKey, string(errCode))
}
