// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchNexusTwirp/twirp.proto

/*
Package TwitchNexusTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchNexusTwirp/twirp.proto
*/
package TwitchNexusTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// TwitchNexus Interface
// =====================

type TwitchNexus interface {
	//
	// Non-authenticated APIs (any user can access):
	//
	GetCategoryShelf(context.Context, *GetCategoryShelfRequest) (*CategoryShelf, error)

	GetStreamerShelf(context.Context, *GetStreamerShelfRequest) (*StreamerShelf, error)

	GetChannelSocialMedia(context.Context, *GetChannelSocialMediaRequest) (*ChannelSocialMediaList, error)

	CreateChannelSocialMedia(context.Context, *CreateChannelSocialMediaRequest) (*ChannelSocialMediaList, error)

	UpdateChannelSocialMedia(context.Context, *UpdateChannelSocialMediaRequest) (*ChannelSocialMediaList, error)

	DeleteChannelSocialMedia(context.Context, *DeleteChannelSocialMediaRequest) (*ChannelSocialMediaList, error)

	// GetAutohostChannels returns a channel's Autohost channels for a given viewer with live channels
	// appearing before offline channels. The relative order of live and offline channels within the
	// list is determined by the channel's Autohost strategy setting:
	//   * PERSONALIZED - GetAutohostChannels orders channels by their affinity to the given viewer.
	//   * MANUAL - GetAutohostChannels uses the creator's ordering.
	GetAutohostChannels(context.Context, *GetAutohostChannelsRequest) (*GetAutohostChannelsResponse, error)

	// GetAutohostChannelForCarousel returns a live channel on the given channel's Autohost list that is meant
	// to be shown in the carousel on the offline channel page.
	//
	// When the channel's strategy setting is set to Manual, or when a creator loads their own channel,
	// GetAutohostChannelForCarousel returns the first live channel on the Autohost list as ordered by the creator.
	// Otherwise Recommendations are used to pick the best live channel for the individual viewer.
	GetAutohostChannelForCarousel(context.Context, *GetAutohostChannelForCarouselRequest) (*GetAutohostChannelForCarouselResponse, error)

	// GetAutohostList returns a channel's Autohost list in the order that the creator chose.
	GetAutohostList(context.Context, *GetAutohostListRequest) (*GetAutohostListResponse, error)

	//
	// Authenticated APIs (must be a channel owner/editor):
	//
	GetRecentlyStreamedCategories(context.Context, *GetRecentlyStreamedCategoriesRequest) (*RecentlyStreamedCategories, error)

	GetPreferences(context.Context, *GetPreferencesRequest) (*Preferences, error)

	UpdatePreferences(context.Context, *UpdatePreferencesRequest) (*Preferences, error)

	SetAutohostList(context.Context, *SetAutohostListRequest) (*SetAutohostListResponse, error)

	AddToAutohostList(context.Context, *AddToAutohostListRequest) (*AddToAutohostListResponse, error)

	RemoveFromAutohostList(context.Context, *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error)

	GetAutohostSettings(context.Context, *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error)

	UpdateAutohostSettings(context.Context, *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error)
}

// ===========================
// TwitchNexus Protobuf Client
// ===========================

type twitchNexusProtobufClient struct {
	client HTTPClient
	urls   [17]string
	opts   twirp.ClientOptions
}

// NewTwitchNexusProtobufClient creates a Protobuf client that implements the TwitchNexus interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchNexusProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchNexus {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchNexusPathPrefix
	urls := [17]string{
		prefix + "GetCategoryShelf",
		prefix + "GetStreamerShelf",
		prefix + "GetChannelSocialMedia",
		prefix + "CreateChannelSocialMedia",
		prefix + "UpdateChannelSocialMedia",
		prefix + "DeleteChannelSocialMedia",
		prefix + "GetAutohostChannels",
		prefix + "GetAutohostChannelForCarousel",
		prefix + "GetAutohostList",
		prefix + "GetRecentlyStreamedCategories",
		prefix + "GetPreferences",
		prefix + "UpdatePreferences",
		prefix + "SetAutohostList",
		prefix + "AddToAutohostList",
		prefix + "RemoveFromAutohostList",
		prefix + "GetAutohostSettings",
		prefix + "UpdateAutohostSettings",
	}

	return &twitchNexusProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchNexusProtobufClient) GetCategoryShelf(ctx context.Context, in *GetCategoryShelfRequest) (*CategoryShelf, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryShelf")
	out := new(CategoryShelf)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetStreamerShelf(ctx context.Context, in *GetStreamerShelfRequest) (*StreamerShelf, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamerShelf")
	out := new(StreamerShelf)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetChannelSocialMedia(ctx context.Context, in *GetChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) CreateChannelSocialMedia(ctx context.Context, in *CreateChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) UpdateChannelSocialMedia(ctx context.Context, in *UpdateChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) DeleteChannelSocialMedia(ctx context.Context, in *DeleteChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetAutohostChannels(ctx context.Context, in *GetAutohostChannelsRequest) (*GetAutohostChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannels")
	out := new(GetAutohostChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetAutohostChannelForCarousel(ctx context.Context, in *GetAutohostChannelForCarouselRequest) (*GetAutohostChannelForCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannelForCarousel")
	out := new(GetAutohostChannelForCarouselResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetAutohostList(ctx context.Context, in *GetAutohostListRequest) (*GetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	out := new(GetAutohostListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetRecentlyStreamedCategories(ctx context.Context, in *GetRecentlyStreamedCategoriesRequest) (*RecentlyStreamedCategories, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyStreamedCategories")
	out := new(RecentlyStreamedCategories)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetPreferences(ctx context.Context, in *GetPreferencesRequest) (*Preferences, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetPreferences")
	out := new(Preferences)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) UpdatePreferences(ctx context.Context, in *UpdatePreferencesRequest) (*Preferences, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePreferences")
	out := new(Preferences)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) SetAutohostList(ctx context.Context, in *SetAutohostListRequest) (*SetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	out := new(SetAutohostListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) AddToAutohostList(ctx context.Context, in *AddToAutohostListRequest) (*AddToAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	out := new(AddToAutohostListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) RemoveFromAutohostList(ctx context.Context, in *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	out := new(RemoveFromAutohostListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) GetAutohostSettings(ctx context.Context, in *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	out := new(GetAutohostSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusProtobufClient) UpdateAutohostSettings(ctx context.Context, in *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	out := new(UpdateAutohostSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// TwitchNexus JSON Client
// =======================

type twitchNexusJSONClient struct {
	client HTTPClient
	urls   [17]string
	opts   twirp.ClientOptions
}

// NewTwitchNexusJSONClient creates a JSON client that implements the TwitchNexus interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchNexusJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchNexus {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchNexusPathPrefix
	urls := [17]string{
		prefix + "GetCategoryShelf",
		prefix + "GetStreamerShelf",
		prefix + "GetChannelSocialMedia",
		prefix + "CreateChannelSocialMedia",
		prefix + "UpdateChannelSocialMedia",
		prefix + "DeleteChannelSocialMedia",
		prefix + "GetAutohostChannels",
		prefix + "GetAutohostChannelForCarousel",
		prefix + "GetAutohostList",
		prefix + "GetRecentlyStreamedCategories",
		prefix + "GetPreferences",
		prefix + "UpdatePreferences",
		prefix + "SetAutohostList",
		prefix + "AddToAutohostList",
		prefix + "RemoveFromAutohostList",
		prefix + "GetAutohostSettings",
		prefix + "UpdateAutohostSettings",
	}

	return &twitchNexusJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchNexusJSONClient) GetCategoryShelf(ctx context.Context, in *GetCategoryShelfRequest) (*CategoryShelf, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryShelf")
	out := new(CategoryShelf)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetStreamerShelf(ctx context.Context, in *GetStreamerShelfRequest) (*StreamerShelf, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamerShelf")
	out := new(StreamerShelf)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetChannelSocialMedia(ctx context.Context, in *GetChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) CreateChannelSocialMedia(ctx context.Context, in *CreateChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) UpdateChannelSocialMedia(ctx context.Context, in *UpdateChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) DeleteChannelSocialMedia(ctx context.Context, in *DeleteChannelSocialMediaRequest) (*ChannelSocialMediaList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannelSocialMedia")
	out := new(ChannelSocialMediaList)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetAutohostChannels(ctx context.Context, in *GetAutohostChannelsRequest) (*GetAutohostChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannels")
	out := new(GetAutohostChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetAutohostChannelForCarousel(ctx context.Context, in *GetAutohostChannelForCarouselRequest) (*GetAutohostChannelForCarouselResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannelForCarousel")
	out := new(GetAutohostChannelForCarouselResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetAutohostList(ctx context.Context, in *GetAutohostListRequest) (*GetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	out := new(GetAutohostListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetRecentlyStreamedCategories(ctx context.Context, in *GetRecentlyStreamedCategoriesRequest) (*RecentlyStreamedCategories, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyStreamedCategories")
	out := new(RecentlyStreamedCategories)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetPreferences(ctx context.Context, in *GetPreferencesRequest) (*Preferences, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetPreferences")
	out := new(Preferences)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) UpdatePreferences(ctx context.Context, in *UpdatePreferencesRequest) (*Preferences, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePreferences")
	out := new(Preferences)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) SetAutohostList(ctx context.Context, in *SetAutohostListRequest) (*SetAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	out := new(SetAutohostListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) AddToAutohostList(ctx context.Context, in *AddToAutohostListRequest) (*AddToAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	out := new(AddToAutohostListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) RemoveFromAutohostList(ctx context.Context, in *RemoveFromAutohostListRequest) (*RemoveFromAutohostListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	out := new(RemoveFromAutohostListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) GetAutohostSettings(ctx context.Context, in *GetAutohostSettingsRequest) (*GetAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	out := new(GetAutohostSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchNexusJSONClient) UpdateAutohostSettings(ctx context.Context, in *UpdateAutohostSettingsRequest) (*UpdateAutohostSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	out := new(UpdateAutohostSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// TwitchNexus Server Handler
// ==========================

type twitchNexusServer struct {
	TwitchNexus
	hooks *twirp.ServerHooks
}

func NewTwitchNexusServer(svc TwitchNexus, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchNexusServer{
		TwitchNexus: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchNexusServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchNexusPathPrefix is used for all URL paths on a twirp TwitchNexus server.
// Requests are always: POST TwitchNexusPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchNexusPathPrefix = "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/"

func (s *twitchNexusServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchnexus")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchNexus")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetCategoryShelf":
		s.serveGetCategoryShelf(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetStreamerShelf":
		s.serveGetStreamerShelf(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetChannelSocialMedia":
		s.serveGetChannelSocialMedia(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/CreateChannelSocialMedia":
		s.serveCreateChannelSocialMedia(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/UpdateChannelSocialMedia":
		s.serveUpdateChannelSocialMedia(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/DeleteChannelSocialMedia":
		s.serveDeleteChannelSocialMedia(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetAutohostChannels":
		s.serveGetAutohostChannels(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetAutohostChannelForCarousel":
		s.serveGetAutohostChannelForCarousel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetAutohostList":
		s.serveGetAutohostList(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetRecentlyStreamedCategories":
		s.serveGetRecentlyStreamedCategories(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetPreferences":
		s.serveGetPreferences(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/UpdatePreferences":
		s.serveUpdatePreferences(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/SetAutohostList":
		s.serveSetAutohostList(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/AddToAutohostList":
		s.serveAddToAutohostList(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/RemoveFromAutohostList":
		s.serveRemoveFromAutohostList(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/GetAutohostSettings":
		s.serveGetAutohostSettings(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchnexus.TwitchNexus/UpdateAutohostSettings":
		s.serveUpdateAutohostSettings(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchNexusServer) serveGetCategoryShelf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryShelfJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryShelfProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetCategoryShelfJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryShelf")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryShelfRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CategoryShelf
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetCategoryShelf(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CategoryShelf and nil error while calling GetCategoryShelf. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetCategoryShelfProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryShelf")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoryShelfRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CategoryShelf
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetCategoryShelf(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CategoryShelf and nil error while calling GetCategoryShelf. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetStreamerShelf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamerShelfJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamerShelfProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetStreamerShelfJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamerShelf")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetStreamerShelfRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamerShelf
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetStreamerShelf(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamerShelf and nil error while calling GetStreamerShelf. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetStreamerShelfProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamerShelf")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetStreamerShelfRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamerShelf
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetStreamerShelf(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamerShelf and nil error while calling GetStreamerShelf. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetChannelSocialMedia(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSocialMediaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSocialMediaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetChannelSocialMediaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSocialMediaRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling GetChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetChannelSocialMediaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSocialMediaRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling GetChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveCreateChannelSocialMedia(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateChannelSocialMediaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChannelSocialMediaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveCreateChannelSocialMediaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateChannelSocialMediaRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.CreateChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling CreateChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveCreateChannelSocialMediaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateChannelSocialMediaRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.CreateChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling CreateChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdateChannelSocialMedia(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateChannelSocialMediaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelSocialMediaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveUpdateChannelSocialMediaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateChannelSocialMediaRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdateChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling UpdateChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdateChannelSocialMediaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateChannelSocialMediaRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdateChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling UpdateChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveDeleteChannelSocialMedia(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteChannelSocialMediaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelSocialMediaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveDeleteChannelSocialMediaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteChannelSocialMediaRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.DeleteChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling DeleteChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveDeleteChannelSocialMediaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannelSocialMedia")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteChannelSocialMediaRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ChannelSocialMediaList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.DeleteChannelSocialMedia(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelSocialMediaList and nil error while calling DeleteChannelSocialMedia. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetAutohostChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostChannelsResponse and nil error while calling GetAutohostChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostChannelsResponse and nil error while calling GetAutohostChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostChannelForCarousel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostChannelForCarouselJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostChannelForCarouselProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetAutohostChannelForCarouselJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannelForCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostChannelForCarouselRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostChannelForCarouselResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostChannelForCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostChannelForCarouselResponse and nil error while calling GetAutohostChannelForCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostChannelForCarouselProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostChannelForCarousel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostChannelForCarouselRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostChannelForCarouselResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostChannelForCarousel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostChannelForCarouselResponse and nil error while calling GetAutohostChannelForCarousel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostListResponse and nil error while calling GetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostListResponse and nil error while calling GetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetRecentlyStreamedCategories(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecentlyStreamedCategoriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecentlyStreamedCategoriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetRecentlyStreamedCategoriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyStreamedCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecentlyStreamedCategoriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecentlyStreamedCategories
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetRecentlyStreamedCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecentlyStreamedCategories and nil error while calling GetRecentlyStreamedCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetRecentlyStreamedCategoriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecentlyStreamedCategories")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecentlyStreamedCategoriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecentlyStreamedCategories
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetRecentlyStreamedCategories(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecentlyStreamedCategories and nil error while calling GetRecentlyStreamedCategories. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetPreferences(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPreferencesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPreferencesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetPreferencesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPreferences")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPreferencesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Preferences
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetPreferences(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Preferences and nil error while calling GetPreferences. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetPreferencesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPreferences")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPreferencesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Preferences
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetPreferences(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Preferences and nil error while calling GetPreferences. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdatePreferences(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdatePreferencesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdatePreferencesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveUpdatePreferencesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePreferences")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdatePreferencesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Preferences
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdatePreferences(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Preferences and nil error while calling UpdatePreferences. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdatePreferencesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePreferences")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdatePreferencesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Preferences
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdatePreferences(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Preferences and nil error while calling UpdatePreferences. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveSetAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveSetAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.SetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAutohostListResponse and nil error while calling SetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveSetAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.SetAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAutohostListResponse and nil error while calling SetAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveAddToAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddToAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddToAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveAddToAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddToAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddToAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.AddToAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddToAutohostListResponse and nil error while calling AddToAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveAddToAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddToAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddToAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddToAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.AddToAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddToAutohostListResponse and nil error while calling AddToAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveRemoveFromAutohostList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveFromAutohostListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveFromAutohostListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveRemoveFromAutohostListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveFromAutohostListRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFromAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.RemoveFromAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFromAutohostListResponse and nil error while calling RemoveFromAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveRemoveFromAutohostListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveFromAutohostList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveFromAutohostListRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveFromAutohostListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.RemoveFromAutohostList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveFromAutohostListResponse and nil error while calling RemoveFromAutohostList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutohostSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutohostSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveGetAutohostSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutohostSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostSettingsResponse and nil error while calling GetAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveGetAutohostSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAutohostSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.GetAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutohostSettingsResponse and nil error while calling GetAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdateAutohostSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAutohostSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAutohostSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchNexusServer) serveUpdateAutohostSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAutohostSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdateAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutohostSettingsResponse and nil error while calling UpdateAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) serveUpdateAutohostSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutohostSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateAutohostSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAutohostSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchNexus.UpdateAutohostSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutohostSettingsResponse and nil error while calling UpdateAutohostSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchNexusServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchNexusServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchNexusServer) PathPrefix() string {
	return TwitchNexusPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1792 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0x4f, 0x6f, 0xdb, 0xc8,
	0x15, 0xcf, 0x48, 0x76, 0x6c, 0x3f, 0x27, 0xb6, 0x3c, 0x69, 0x1d, 0x95, 0x71, 0x1c, 0x97, 0x48,
	0x0b, 0xc3, 0x68, 0x65, 0x47, 0x69, 0x8a, 0x3a, 0xa9, 0x9b, 0xca, 0x96, 0x62, 0xb9, 0xf0, 0x3f,
	0x90, 0xb2, 0x81, 0x04, 0x45, 0x5c, 0x5a, 0x1c, 0x4b, 0x6c, 0x29, 0x52, 0x21, 0x87, 0x8e, 0x95,
	0xa2, 0x45, 0x0a, 0x74, 0x81, 0x3d, 0x2c, 0xf6, 0xb2, 0xd9, 0xc5, 0xe6, 0xb0, 0x08, 0xb0, 0x97,
	0xbd, 0xec, 0x69, 0xbf, 0xd2, 0x1e, 0xf6, 0xba, 0x1f, 0x61, 0x41, 0x72, 0x24, 0xf1, 0xaf, 0x44,
	0x49, 0x89, 0xf7, 0x62, 0x68, 0x66, 0x38, 0xbf, 0xf7, 0x7b, 0x6f, 0xde, 0xbc, 0x79, 0xef, 0xc1,
	0xb0, 0x56, 0xd5, 0x65, 0x92, 0xfb, 0xa7, 0x65, 0x52, 0x45, 0xcb, 0xd1, 0xf3, 0x55, 0xa9, 0xf1,
	0x4a, 0x5b, 0xad, 0xbc, 0x54, 0x68, 0xb5, 0xbe, 0x4f, 0x2e, 0x2c, 0xb3, 0xf2, 0x52, 0x31, 0x9a,
	0xab, 0xd4, 0xfe, 0x9b, 0x6b, 0x1a, 0x3a, 0xd5, 0xf1, 0xaf, 0xa9, 0xb3, 0x9a, 0x3b, 0xb3, 0x54,
	0xaa, 0x6b, 0x39, 0x72, 0x21, 0x35, 0x9a, 0x2a, 0xc9, 0xb9, 0xb3, 0x9a, 0xbd, 0x87, 0x5b, 0xac,
	0xe9, 0x7a, 0x4d, 0x25, 0xab, 0xce, 0x86, 0x53, 0xeb, 0x6c, 0xf5, 0xa5, 0x21, 0x35, 0x9b, 0xc4,
	0x30, 0x5d, 0x08, 0x7e, 0x02, 0xc6, 0x4b, 0x8d, 0x26, 0x6d, 0xf1, 0x7b, 0x70, 0x73, 0x9b, 0xd0,
	0x2d, 0x89, 0x92, 0x9a, 0x6e, 0xb4, 0xc4, 0x3a, 0x51, 0xcf, 0x04, 0xf2, 0xc2, 0x22, 0x26, 0xc5,
	0x0b, 0x30, 0x55, 0xad, 0x4b, 0x9a, 0x46, 0xd4, 0x9d, 0x62, 0x16, 0x2d, 0xa1, 0xe5, 0x29, 0xa1,
	0x3b, 0x81, 0x7f, 0x01, 0xe3, 0xaa, 0xd2, 0x50, 0x68, 0x36, 0xb5, 0x84, 0x96, 0xd3, 0x82, 0x3b,
	0xe0, 0xdf, 0x21, 0x07, 0x4f, 0xa4, 0x06, 0x91, 0x1a, 0xc4, 0x18, 0x15, 0x0f, 0x1f, 0xc2, 0xb4,
	0x65, 0x12, 0x63, 0x4b, 0xd7, 0x28, 0xb9, 0xa0, 0xd9, 0xf4, 0x12, 0x5a, 0x9e, 0xce, 0xe7, 0x72,
	0x7d, 0x0d, 0x90, 0x3b, 0xea, 0xee, 0x12, 0xbc, 0x10, 0xbc, 0x06, 0x0b, 0xb6, 0xc2, 0xae, 0x5c,
	0x51, 0xaf, 0x2a, 0x92, 0xba, 0x47, 0x64, 0x45, 0x4a, 0xc6, 0x72, 0x0d, 0x6e, 0x48, 0x16, 0xad,
	0x13, 0x8d, 0x2a, 0x55, 0x89, 0x12, 0xd9, 0x16, 0xb3, 0x53, 0x74, 0x38, 0x4f, 0x09, 0x51, 0x4b,
	0xfc, 0xb7, 0x29, 0xb8, 0xb3, 0x65, 0x10, 0x89, 0x92, 0x4b, 0x93, 0x89, 0xff, 0x0b, 0x19, 0xb3,
	0x2b, 0x65, 0x87, 0x92, 0x86, 0x99, 0x4d, 0x2f, 0xa5, 0x97, 0xa7, 0xf3, 0x42, 0x02, 0xd3, 0xf5,
	0x61, 0x9b, 0x13, 0xfd, 0xd0, 0x42, 0x48, 0x16, 0xb7, 0x0e, 0xb3, 0x81, 0x8f, 0x70, 0x06, 0xd2,
	0x96, 0xa1, 0x32, 0xe5, 0xec, 0x9f, 0xf6, 0x81, 0x53, 0x85, 0xaa, 0x84, 0x29, 0xe2, 0x0e, 0xf8,
	0x2f, 0x53, 0x70, 0xe7, 0xa8, 0x29, 0x5f, 0xaa, 0xb9, 0x72, 0x2e, 0x37, 0xd7, 0xb9, 0x16, 0x72,
	0xee, 0xd5, 0xc9, 0xb5, 0xaf, 0x4e, 0x4e, 0xa4, 0x86, 0xa2, 0xd5, 0x8e, 0x25, 0xd5, 0x22, 0x2e,
	0xf3, 0x7c, 0x9b, 0xf9, 0x58, 0x82, 0x1d, 0xee, 0xa7, 0x78, 0x06, 0x52, 0x8a, 0x9c, 0x1d, 0x77,
	0x48, 0xa4, 0x14, 0x19, 0xdf, 0x83, 0x71, 0x45, 0x93, 0xc9, 0x45, 0xf6, 0xaa, 0x83, 0x71, 0x2b,
	0x84, 0xb1, 0xa3, 0xd1, 0xfb, 0x79, 0x06, 0xe1, 0x7c, 0xc9, 0xff, 0x0f, 0xc1, 0x9d, 0x22, 0x51,
	0x49, 0x2f, 0xd3, 0xb8, 0x62, 0x50, 0x47, 0x8c, 0xcf, 0x54, 0xa9, 0x84, 0xa6, 0x4a, 0xc7, 0x7b,
	0xb3, 0x02, 0xf3, 0x61, 0xe1, 0xbb, 0x8a, 0x49, 0xf1, 0x01, 0x4c, 0x18, 0xc4, 0xb4, 0x54, 0x6a,
	0x66, 0x91, 0xe3, 0x6a, 0x0f, 0x92, 0xb8, 0x5a, 0x58, 0x91, 0x36, 0x0a, 0xff, 0x0f, 0xc0, 0xe1,
	0xe5, 0x90, 0x82, 0xcc, 0xaf, 0x52, 0x5d, 0xbf, 0xc2, 0x30, 0xa6, 0x49, 0x0d, 0xc2, 0xb4, 0x70,
	0x7e, 0x77, 0x7d, 0x6d, 0xcc, 0xeb, 0x6b, 0xf7, 0xe0, 0xba, 0x2f, 0xf0, 0xe1, 0x25, 0x98, 0xae,
	0xb2, 0x89, 0x9d, 0xa2, 0xab, 0xc7, 0x94, 0xe0, 0x9d, 0xe2, 0x8f, 0x61, 0xb6, 0x4c, 0x0c, 0xfd,
	0xd0, 0x20, 0x26, 0xa1, 0xce, 0xe9, 0xe0, 0x2d, 0x18, 0x3f, 0xb7, 0x7f, 0x38, 0xa4, 0x66, 0xf2,
	0xbf, 0x4f, 0xa0, 0x76, 0x17, 0x42, 0x70, 0xf7, 0xf2, 0x32, 0xcc, 0xfb, 0x62, 0x66, 0xa5, 0xd5,
	0x24, 0x2e, 0xfc, 0xdf, 0xfc, 0xf0, 0x7f, 0x48, 0x00, 0x1f, 0x42, 0x6a, 0x4b, 0x79, 0x87, 0xe0,
	0xba, 0x6f, 0x11, 0x67, 0x61, 0xc2, 0x72, 0x4e, 0xb6, 0xad, 0x6d, 0x7b, 0x88, 0xcb, 0x30, 0x46,
	0x5b, 0x4d, 0xf7, 0x76, 0x0e, 0x2b, 0xd6, 0x41, 0xc0, 0x2b, 0x90, 0x69, 0xe8, 0x32, 0x51, 0x2b,
	0x86, 0x54, 0xfd, 0x97, 0xa2, 0xd5, 0x6c, 0x61, 0x69, 0x47, 0x58, 0x68, 0x9e, 0xff, 0x04, 0xc1,
	0xdd, 0x6d, 0x42, 0x05, 0x52, 0x25, 0x1a, 0x55, 0x5b, 0x0c, 0x52, 0x66, 0xc7, 0xa4, 0x10, 0xf3,
	0x43, 0xc5, 0x80, 0xce, 0xf3, 0x93, 0xf6, 0x3e, 0x67, 0x6f, 0x11, 0x70, 0xf1, 0x5c, 0xf0, 0xbf,
	0x81, 0x33, 0x62, 0x57, 0xd9, 0x35, 0x78, 0x94, 0xc0, 0x72, 0x31, 0x22, 0x5a, 0x42, 0x0f, 0x78,
	0xfe, 0x18, 0xb2, 0x71, 0xfb, 0xf0, 0x22, 0x40, 0xd7, 0x6b, 0x99, 0x79, 0x3c, 0x33, 0x98, 0x83,
	0x49, 0xc5, 0x2c, 0x2b, 0xb2, 0x4c, 0x34, 0xc7, 0x28, 0x93, 0x42, 0x67, 0xcc, 0x3f, 0x80, 0x5f,
	0x6e, 0x13, 0x7a, 0x68, 0x90, 0x33, 0x62, 0x10, 0xad, 0x9a, 0xd0, 0xe4, 0xfc, 0xff, 0x53, 0x30,
	0xed, 0xd9, 0x84, 0x4f, 0x61, 0xce, 0x0c, 0x3a, 0xc4, 0x48, 0x3e, 0x1c, 0x86, 0xc3, 0x7b, 0x00,
	0xf5, 0xce, 0x55, 0x62, 0x9e, 0x3a, 0xe0, 0xfd, 0xf3, 0x00, 0xe0, 0x4d, 0x58, 0x50, 0x4c, 0x57,
	0xb0, 0x58, 0xad, 0x13, 0xd9, 0x52, 0x89, 0xd8, 0xd2, 0xaa, 0x45, 0xc5, 0x94, 0x4e, 0x55, 0x22,
	0x3b, 0xae, 0x31, 0x29, 0xf4, 0xfc, 0x86, 0xff, 0x21, 0x0d, 0x59, 0xf7, 0xfd, 0x1a, 0xd4, 0x82,
	0x43, 0x38, 0x6d, 0x2d, 0xca, 0xc6, 0xee, 0x33, 0xb6, 0x3e, 0x8c, 0x8d, 0xdd, 0xe7, 0x26, 0xc2,
	0xd0, 0xbf, 0x83, 0x39, 0x4f, 0x14, 0xac, 0xe8, 0x65, 0x45, 0xb6, 0x63, 0xa9, 0x7d, 0x87, 0xc3,
	0x0b, 0xb6, 0x22, 0xbe, 0xc9, 0x23, 0xad, 0x6e, 0x7f, 0x3f, 0xee, 0x7c, 0x1f, 0xb5, 0x84, 0x05,
	0xdf, 0x41, 0xba, 0x4f, 0x62, 0x7e, 0xa0, 0x83, 0x74, 0xa9, 0x7b, 0x4f, 0xf3, 0x79, 0x9f, 0xd3,
	0x9c, 0x70, 0xa4, 0x70, 0xa1, 0x87, 0x77, 0x53, 0xd7, 0x55, 0x17, 0xad, 0xf7, 0x49, 0x7f, 0x8e,
	0x60, 0xda, 0x93, 0x65, 0xda, 0x77, 0x4a, 0x26, 0xe7, 0x4a, 0x95, 0x74, 0xce, 0xb6, 0x33, 0xc6,
	0xf3, 0x70, 0xd5, 0xf2, 0x9e, 0x26, 0x1b, 0xd9, 0x7b, 0x9a, 0xaa, 0x44, 0xcf, 0x74, 0xa3, 0xc1,
	0xde, 0xab, 0xce, 0xd8, 0x76, 0x16, 0x55, 0xd2, 0x6a, 0x96, 0x54, 0x23, 0x26, 0xb3, 0x75, 0x77,
	0xc2, 0x0e, 0xdc, 0x55, 0xdd, 0xd2, 0xa8, 0xd1, 0x62, 0x49, 0x45, 0x7b, 0xc8, 0x3f, 0x85, 0xd9,
	0x82, 0x45, 0xf5, 0xba, 0x6e, 0xb6, 0xb3, 0xdc, 0x3e, 0x7e, 0xb7, 0x0c, 0xb3, 0x81, 0x38, 0xcc,
	0x58, 0x06, 0xa7, 0xf9, 0xaf, 0x11, 0x70, 0xdb, 0x84, 0x06, 0xe0, 0x3b, 0xee, 0x1d, 0x48, 0xd6,
	0xd1, 0xc8, 0xc9, 0x7a, 0x9f, 0xf4, 0x25, 0x3a, 0x66, 0xff, 0x07, 0x6e, 0x45, 0x72, 0x34, 0x9b,
	0xba, 0x66, 0x12, 0xfc, 0x1c, 0x32, 0x52, 0x60, 0x8d, 0x45, 0xea, 0x24, 0x0e, 0x17, 0x80, 0x15,
	0x42, 0x58, 0xfc, 0x17, 0xee, 0x0b, 0x16, 0xf8, 0xf0, 0x89, 0x6e, 0x6c, 0x49, 0x86, 0x6e, 0x99,
	0x44, 0xfd, 0x99, 0xac, 0xc5, 0x7f, 0x84, 0xe0, 0x37, 0x7d, 0x88, 0x31, 0x13, 0xfd, 0x1d, 0x66,
	0x03, 0x6a, 0x31, 0x76, 0xc3, 0x58, 0x28, 0x08, 0xc5, 0xef, 0xc2, 0xbc, 0x87, 0x86, 0x9d, 0x3b,
	0x8e, 0x52, 0x70, 0x6e, 0x38, 0xf5, 0xa6, 0x1f, 0x8d, 0xa9, 0xc1, 0xc3, 0x35, 0xc9, 0x33, 0xcf,
	0x12, 0x1c, 0xdf, 0x9c, 0x9d, 0x6f, 0xcc, 0x8b, 0xd1, 0x6c, 0x62, 0xc2, 0x31, 0x8a, 0x0f, 0xc7,
	0xbd, 0xbd, 0x35, 0x48, 0x27, 0x1d, 0x41, 0x67, 0x03, 0x6e, 0x8a, 0x23, 0x68, 0xf3, 0x06, 0x41,
	0xb6, 0x20, 0xcb, 0x15, 0xfd, 0x32, 0xf4, 0x59, 0x86, 0xd9, 0xce, 0xc0, 0xac, 0xe8, 0x05, 0x59,
	0x66, 0x2a, 0x05, 0xa7, 0xf9, 0xc7, 0xf0, 0xab, 0x08, 0x56, 0x03, 0xe8, 0xf5, 0x0e, 0xc1, 0x6d,
	0x81, 0x34, 0xf4, 0x73, 0xf2, 0xc4, 0xd0, 0x1b, 0x97, 0xa1, 0x5c, 0x0e, 0xb0, 0x57, 0x0b, 0x57,
	0x38, 0xd3, 0x2f, 0x62, 0x85, 0x2f, 0xc2, 0x62, 0x1c, 0xc1, 0x01, 0xf4, 0x54, 0x7d, 0xe1, 0x55,
	0x24, 0x94, 0x2a, 0x5a, 0xcd, 0xfc, 0x40, 0x3a, 0xf2, 0x9a, 0x2f, 0x50, 0x76, 0xa5, 0x31, 0xc2,
	0x07, 0x30, 0x69, 0xb2, 0x39, 0x76, 0xfd, 0xef, 0x0f, 0x70, 0xfd, 0x3b, 0x70, 0x1d, 0x10, 0xfe,
	0x4d, 0x1a, 0x6e, 0xbb, 0xa9, 0xd1, 0x25, 0x69, 0xe8, 0xa8, 0x40, 0x0d, 0x3b, 0xdf, 0x68, 0x39,
	0x6f, 0xc4, 0xcc, 0x60, 0x2a, 0xb0, 0xad, 0x42, 0x07, 0x04, 0xef, 0xda, 0x99, 0x8d, 0x1b, 0x2d,
	0xb7, 0x24, 0x43, 0x2e, 0x69, 0x6e, 0x2a, 0x31, 0xd6, 0x37, 0x95, 0x88, 0xda, 0x86, 0xff, 0x08,
	0x93, 0x94, 0x48, 0x8d, 0xb2, 0x6e, 0x52, 0xe7, 0x11, 0xef, 0x0d, 0xd1, 0xf9, 0xd6, 0x66, 0x21,
	0x93, 0xa6, 0xa1, 0xe8, 0x86, 0x42, 0x95, 0x57, 0xe4, 0x58, 0x97, 0xab, 0x92, 0xd9, 0x4e, 0x9b,
	0x7a, 0xb2, 0x88, 0xd8, 0xc6, 0xbf, 0x80, 0xc5, 0xb8, 0x53, 0xf9, 0x50, 0x9e, 0xf0, 0x3d, 0x82,
	0x4c, 0x70, 0xd9, 0x77, 0x58, 0xe8, 0x7d, 0x1c, 0xd6, 0x5a, 0xf4, 0x61, 0xb9, 0xf5, 0x4e, 0xe4,
	0x81, 0x70, 0x9e, 0x03, 0x71, 0x93, 0xfd, 0xae, 0xd1, 0xd7, 0xa2, 0x8d, 0x3e, 0xe6, 0xa2, 0x45,
	0x2c, 0xad, 0xe4, 0x01, 0xba, 0xf9, 0x29, 0x9e, 0x83, 0xeb, 0xe5, 0x92, 0x70, 0x70, 0x72, 0x28,
	0x94, 0xc4, 0x52, 0xe5, 0xe4, 0x5e, 0xe6, 0x4a, 0x70, 0x2a, 0x9f, 0x41, 0x2b, 0xeb, 0x30, 0x17,
	0xca, 0xca, 0xf1, 0x35, 0x98, 0x2c, 0x1c, 0x55, 0x0e, 0xca, 0x07, 0x62, 0x25, 0x73, 0x05, 0x4f,
	0xc2, 0x58, 0xa5, 0x54, 0xd8, 0xcb, 0x20, 0x7b, 0xbe, 0xb8, 0x23, 0x16, 0x36, 0x77, 0x4b, 0xc5,
	0x4c, 0x6a, 0xe5, 0x85, 0xc7, 0xa6, 0x6d, 0x13, 0xdc, 0x82, 0x9b, 0xed, 0x9d, 0x27, 0x62, 0x45,
	0x28, 0x54, 0x4a, 0xdb, 0x4f, 0x4f, 0x8e, 0xf6, 0xc5, 0x92, 0x0d, 0xb4, 0x00, 0xd9, 0xf0, 0xe2,
	0x5e, 0x61, 0xff, 0xa8, 0xb0, 0x9b, 0x41, 0x98, 0x87, 0xc5, 0xf0, 0xea, 0x61, 0x49, 0x10, 0x0f,
	0xf6, 0x0b, 0xbb, 0x3b, 0xcf, 0x6c, 0x91, 0xf9, 0x1f, 0x6f, 0xc0, 0xb4, 0xa7, 0x53, 0x8d, 0x5f,
	0x23, 0xc8, 0x04, 0xbb, 0xc9, 0xf8, 0x61, 0x82, 0x53, 0x8c, 0x69, 0x41, 0x73, 0x6b, 0x49, 0x7a,
	0x48, 0x3e, 0x69, 0x8c, 0x82, 0xbf, 0xcb, 0x91, 0x90, 0x42, 0x54, 0xd7, 0x3a, 0x11, 0x05, 0xbf,
	0xb4, 0xcf, 0x90, 0x53, 0x41, 0x47, 0x34, 0xaf, 0x1e, 0x27, 0x34, 0x45, 0x5c, 0x7b, 0x8f, 0x5b,
	0x1f, 0xaa, 0xa7, 0xe6, 0xf4, 0xe7, 0xde, 0x22, 0xc8, 0xc6, 0x75, 0x76, 0xf1, 0xe6, 0xe8, 0x6d,
	0xe1, 0x51, 0xb9, 0xc5, 0x35, 0x7d, 0x13, 0x71, 0xeb, 0xd3, 0x31, 0x1e, 0x95, 0x5b, 0x5c, 0xd7,
	0x35, 0x11, 0xb7, 0x3e, 0x2d, 0xdb, 0x51, 0xb8, 0xbd, 0x41, 0x70, 0x23, 0xa2, 0xd6, 0xc1, 0x1b,
	0xc9, 0xfc, 0x2c, 0xa6, 0x8e, 0xe3, 0xfe, 0x32, 0xec, 0x76, 0xf6, 0x5e, 0x7c, 0x87, 0xe0, 0x76,
	0xcf, 0x4a, 0x03, 0x6f, 0x0f, 0x25, 0x21, 0x5c, 0x44, 0x71, 0xe5, 0xd1, 0x81, 0x18, 0xe9, 0x8f,
	0x11, 0xcc, 0x06, 0x2a, 0x09, 0xbc, 0x3e, 0x18, 0xba, 0x27, 0x21, 0xe5, 0x1e, 0x0e, 0xb3, 0x95,
	0x51, 0xf9, 0xc6, 0xb5, 0x5f, 0x8f, 0xc6, 0x63, 0x42, 0xfb, 0xf5, 0x6d, 0xa3, 0x72, 0x1b, 0xc3,
	0x77, 0x27, 0x6d, 0x1e, 0xaf, 0x60, 0xc6, 0xdf, 0x2b, 0xc4, 0x7f, 0x4a, 0xc6, 0x2c, 0xdc, 0x1c,
	0xe3, 0x92, 0x94, 0xbe, 0x5e, 0x49, 0xaf, 0x11, 0xcc, 0x85, 0x3a, 0x6d, 0xf8, 0x51, 0xe2, 0x68,
	0xf1, 0x1e, 0x28, 0xd8, 0x3e, 0x23, 0x0e, 0xe1, 0x33, 0xe2, 0xf0, 0x3e, 0x13, 0x57, 0x1e, 0x7e,
	0x8a, 0x60, 0x2e, 0x54, 0x64, 0x25, 0xb2, 0x46, 0x5c, 0xc1, 0xc8, 0xfd, 0x79, 0xb8, 0xcd, 0x8c,
	0xd0, 0x57, 0x08, 0xe6, 0xa3, 0x4b, 0x22, 0xfc, 0xd7, 0x44, 0x4e, 0xd7, 0xa3, 0xdc, 0xe3, 0x0a,
	0x23, 0x20, 0x30, 0x7e, 0x81, 0xd8, 0xd9, 0x49, 0x43, 0x07, 0x8c, 0x9d, 0x81, 0x12, 0x66, 0xd0,
	0xd8, 0x19, 0xca, 0xb5, 0x6d, 0xb3, 0x45, 0xa7, 0xe3, 0x89, 0xcc, 0xd6, 0xb3, 0xbe, 0x4a, 0x64,
	0xb6, 0xde, 0xb5, 0xc0, 0xe6, 0x6f, 0x9f, 0xdd, 0x4d, 0xf2, 0xff, 0x0a, 0xa7, 0x57, 0x9d, 0xf2,
	0xe3, 0xfe, 0x4f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x7d, 0x4a, 0x68, 0x57, 0xde, 0x20, 0x00, 0x00,
}
