package datakeycache

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestDecryptionKeyCacheCompositeKey(t *testing.T) {
	t.Run("has repeatable serialization", func(t *testing.T) {
		compositeKey := DecryptionKeyCacheCompositeKey{
			EncryptedDataKey:  []byte("ENCRYPTEDDATAKEY"),
			KeyProviderID:     "KEYPROVIDERID",
			KeyInfo:           "KEYINFO",
			AlgorithmID:       "ALGORITHMID",
			EncryptionContext: map[string]string{"keyA": "valueA", "keyB": "valueB"},
		}

		expected := compositeKey.Key()
		for n := 0; n < 100; n++ {
			assert.Equal(t, expected, compositeKey.Key())
		}
	})
}
