package encryptioncontext

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSerialize(t *testing.T) {
	t.Run("ordered", func(t *testing.T) {
		ec := map[string]string{
			"c": "value",
			"b": "value",
			"a": "value",
		}

		bs := Serialize(ec)
		assert.Equal(t, []byte("a value b value c value "), bs)
	})

	t.Run("empty context", func(t *testing.T) {
		assert.Empty(t, Serialize(map[string]string{}))
	})
}
