package keybytes

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestCopyAndZero(t *testing.T) {
	t.Run("zero on a copied slice doesn't zero original slice", func(t *testing.T) {
		a := []byte("data")
		b := Copy(a)
		Zero(a)
		require.Equal(t, []byte{0, 0, 0, 0}, a)
		require.NotEmpty(t, b)
	})
}
